// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimationInstance.h,v 1.12 2000/03/25 06:44:28 wjs Exp $

#import <OIF/OIImage.h>

@class OFScheduledEvent;
@class OIAnimation, OIAnimationFrame;

@interface OIAnimationInstance : OIImage <OIImageObserver>
{
    OIAnimation *animation;
    OIAnimationFrame *frame;
    unsigned int remainingLoops;
    unsigned int nextFrame;
    OFScheduledEvent *nextFrameEvent;
}

- initWithAnimation:(OIAnimation *)animation;

// Called by the animation, possibly from another thread.
- (void)animationEnded;
- (void)animationReceivedFrame:(OIAnimationFrame *)frame;

@end
