// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OIAnimationToInstanceProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OIF/OIAnimation.h>
#import <OIF/OIAnimationInstance.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimationToInstanceProcessor.m,v 1.6 2000/03/25 06:44:28 wjs Exp $")

@implementation OIAnimationToInstanceProcessor

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentTypeString:@"omni/animation" toContentTypeString:@"omni/image" cost:0.1];
}

- initWithPipeline:(OWPipeline *)aPipeline;
{
    self = [super initWithPipeline:aPipeline];
    
    if (!self)
        return nil;

    animation = [pipeline lastContent];
    OBASSERT([animation isKindOfClass:[OIAnimation class]]);
    [animation retain];

    return self;
}

- (void)dealloc;
{
    [animation release];
    [super dealloc];
}

// Normally, startProcessing invokes -processInThread in a subthread, which calls a couple of status-updating methods and calls -process. There's no need to create a subthread for something this simple, however.
- (void)startProcessing;
{
    [self processBegin];
    
    [pipeline addContent:[animation animationInstance]];
    [pipeline cacheContent];
    [pipeline startProcessingContent];

    [self processEnd];
    [self retire];
}
    
@end
