// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIImageProcessor.h,v 1.10 2000/03/01 18:17:36 kc Exp $

#import <OWF/OWDataStreamProcessor.h>

@class NSMutableArray;
@class NSImage;
@class OIImage;

#import <Foundation/NSDate.h> // For NSTimeInterval
#import <Foundation/NSGeometry.h> // For NSSize
#import <OmniFoundation/OFByte.h>

@interface OIImageProcessor : OWDataStreamProcessor
{
    OIImage *omniImage;
@private
    NSImage *lastImage;
    BOOL needUpdate;

    NSTimeInterval lastDrawTimeInterval;
    NSTimeInterval drawInterval;
}

// These methods are called by our subclasses.

- (void)addOmniImageToPipelineIfIncrementalDisplayIsDesired;

- (void)setImage:(NSImage *)anImage;
    // set the image, but don't actually try to draw it or anything.

- (void)setImageSize:(NSSize)newImageSize;
    // Set this as soon as the image dimensions are known.

- (BOOL)drawIntervalReached;
    // Returns YES when it's time to draw again.

- (void)flushImage;
    // Call this while decoding the image into resultImage.  It will only call updateImage: if it has been OmniImageProcessorDrawInterval seconds since the last updateImage:.

- (void)updateImage:(NSImage *)anImage;
    // This manually flushes the image to the screen.

- (void)fillGammaCorrectionTable:(OFByte[256])gammaCorrectionTable withSamplesOfGamma:(double)gamma;

@end

#import "FrameworkDefines.h"

OIF_EXTERN int OIImageProcessorCheckTimeEveryNRows;
