// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OIF/OIAnimationFrame.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimationFrame.m,v 1.12 2000/03/25 06:44:28 wjs Exp $")

@implementation OIAnimationFrame

static NSString *OIAnimationMinimumDelayIntervalKey = @"OIAnimationMinimumDelayInterval";

+ (void)initialize;
{
    /* We used to crash when two threads simultaneously called -initWithDelayInterval: for its first call ever.  Stack traces were always something like this:

    thread 4:
    
        #0  0x41301258 in objc_msgSend ()
        #1  0x42505544 in -[NSConcreteMutableDictionary objectForKey:] ()
        #2  0x10ce5f8 in -[OFUserDefaults objectForKey:] (self=0xb023b0, _cmd=0x4369d254, defaultName=0xa57090) at OFUserDefaults.m:209
        #3  0x10ceb30 in -[OFUserDefaults stringForKey:] (self=0xa57090, _cmd=0x4369d254, defaultName=0xa57090) at OFUserDefaults.m:319
        #4  0x10ce98c in -[OFUserDefaults floatForKey:] (self=0xa57090, _cmd=0x4369d254, defaultName=0xa57090) at OFUserDefaults.m:283
        #5  0xa531c0 in -[OIAnimationFrame initWithDelayInterval:] (self=0x2108b80, _cmd=0x4369d254, aDelayInterval=0) at OIAnimationFrame.m:21
        #6  0x21604d4 in -[OIGifImageProcessor(Private) setAnimationFrameFromData:] ()
        #7  0x215f194 in -[OIGifImageProcessor(Private) parseImage] ()

    thread 6:

        #0  0x4132d368 in msg_receive_trap ()
        #1  0x4132d0ac in msg_receive ()
        #2  0x4251ec14 in condition_wait_timeout ()
        #3  0x42506c70 in -[NSRecursiveLock lock] ()
        #4  0x10ce5d0 in -[OFUserDefaults objectForKey:] (self=0xb023b0, _cmd=0x100, defaultName=0xa57090) at OFUserDefaults.m:206
        #5  0x10ceb30 in -[OFUserDefaults stringForKey:] (self=0x18f2a98, _cmd=0x100, defaultName=0x18) at OFUserDefaults.m:319
        #6  0x10ce98c in -[OFUserDefaults floatForKey:] (self=0x18f2a98, _cmd=0x100, defaultName=0x18) at OFUserDefaults.m:283
        #7  0xa531c0 in -[OIAnimationFrame initWithDelayInterval:] (self=0x2138ed8, _cmd=0x100, aDelayInterval=0) at OIAnimationFrame.m:21
        #8  0x21604d4 in -[OIGifImageProcessor(Private) setAnimationFrameFromData:] ()
        #9  0x215f194 in -[OIGifImageProcessor(Private) parseImage] ()

    I believe this is a thread-unsafe bug in the way @"" strings work, but I haven't had a chance to prove or disprove that.  However, that's why this code is here:  by sending a message to the string before we go multithreaded, I'm hoping to avoid triggering that bug.

    */
    
    [OIAnimationMinimumDelayIntervalKey self];
}

- initWithDelayInterval:(NSTimeInterval)aDelayInterval;
{
    NSTimeInterval minimumDelayInterval;

    if (![super init])
	return nil;

    minimumDelayInterval = [[NSUserDefaults standardUserDefaults] floatForKey:OIAnimationMinimumDelayIntervalKey];
    if (aDelayInterval < minimumDelayInterval)
	delayInterval = minimumDelayInterval;
    else
        delayInterval = aDelayInterval;
    return self;
}

- (NSTimeInterval)delayInterval;
{
    return delayInterval;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary setObject:[NSNumber numberWithDouble:delayInterval] forKey:@"delayInterval"];
    return debugDictionary;
}


@end
