// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIImage.h,v 1.15 2000/07/14 07:26:50 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSData, NSMutableArray;
@class NSImage;

#import <Foundation/NSGeometry.h> // For NSSize
#import <OmniFoundation/OFByte.h>
#import <OWF/OWContentProtocol.h>
#import <OIF/OIImageObserverProtocol.h>
#import <OIF/OIImageSourceDataProtocol.h>

@interface OIImage : OWAbstractContent
{
    BOOL haveSize;
    NSSize imageSize;
    NSImage *nsImage;

    NSMutableArray *observerValues;
    id <OIImageSourceData> sourceData;
}

+ (OWContentType *)contentType;

// Gamma utility methods

+ (double)sourceGamma;
    // Standard is sRGB, approximately 2.2
+ (double)targetGamma;
    // Standard Macintosh monitors use 1.8
+ (double)gammaCorrection;
    // +sourceGamma / +targetGamma
+ (void)fillGammaCorrectionTable:(OFByte[256])gammaCorrectionTable withSamplesOfGamma:(double)gamma;

// Image API

- (BOOL)hasSize;
- (NSSize)size;
- (void)setSize:(NSSize)newSize;
- (NSImage *)image;

- (void)updateImage:(NSImage *)anImage;
- (void)abortImage;

- (void)startAnimation;
- (void)stopAnimation;

- (void)addObserver:(id <OIImageObserver>)anObserver;
    // Subscribed anObserver to receive messages described in the OIImageObserver protocol.  The new observer is not retained.  The new observer is responsible for unsubscribing itself before it gets deallocated.

- (void)removeObserver:(id <OIImageObserver>)anObserver;
    // Unsubscribes anObserver such that it will not receive the messages described in the OIImageObserver protocol.

- (void)setSourceData:(id <OIImageSourceData>)imageSourceData;

@end
