// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OIF/OIBitmapImageProcessor.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OIF/OIImage.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIBitmapImageProcessor.m,v 1.9 2000/03/25 06:44:28 wjs Exp $")

@implementation OIBitmapImageProcessor

- (void)dealloc;
{
    [resultImageRep release];
    [super dealloc];
}

- (void)setImageRep:(NSBitmapImageRep *)imageRep;
{
    NSImage *newImage;

    if (resultImageRep == imageRep)
	return;

    [resultImageRep release];
    resultImageRep = [imageRep retain];

    newImage = [[[NSImage allocWithZone:[omniImage zone]] init] autorelease];

    [newImage setDataRetained:YES];
    [newImage setCachedSeparately:YES];
    [newImage addRepresentation:imageRep];
    [self setImage:newImage];

    isPlanar = [imageRep isPlanar];
    numberOfPlanes = [imageRep numberOfPlanes];
    OBASSERT(numberOfPlanes <= OIBitmapImageProcessor_MaxPlanes);
    [imageRep getBitmapDataPlanes:(unsigned char **)imageDataPlanes];
}

- (NSBitmapImageRep *)imageRep;
{
    return resultImageRep;
}

- (unsigned char **)imageDataPlanes;
{
    return (unsigned char **)imageDataPlanes;
}

@end
