// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimationInstance.h,v 1.14 2000/10/23 08:41:00 kc Exp $

#import <OIF/OIImage.h>

@class OFScheduledEvent;
@class OIAnimation, OIAnimationFrame;

#import <OmniFoundation/OFWeakRetainConcreteImplementation.h>

@interface OIAnimationInstance : OIImage <OIImageObserver, OFWeakRetain>
{
    OIAnimation *animation;
    OIAnimationFrame *frame;
    unsigned int remainingLoops;
    unsigned int nextFrame;
    OFScheduledEvent *nextFrameEvent;
    NSLock *nextFrameEventLock;

    OFWeakRetainConcreteImplementation_IVARS;
}

- initWithAnimation:(OIAnimation *)animation;

// Called by the animation, possibly from another thread.
- (void)animationEnded;
- (void)animationReceivedFrame:(OIAnimationFrame *)aFrame;

OFWeakRetainConcreteImplementation_INTERFACE

@end
