// Copyright 1998-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OIF/OIImageProcessor.h>

#import <math.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OIF/OIImage.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIImageProcessor.m,v 1.17 2001/02/15 15:11:50 kc Exp $")

@interface OIImageProcessor (Private)
- (void)addOmniImageToPipeline;
@end

@implementation OIImageProcessor

int OIImageProcessorCheckTimeEveryNRows = 16;

- initWithPipeline:(OWPipeline *)aPipeline;
{
    if (![super initWithPipeline:aPipeline])
        return nil;

    omniImage = [[OIImage allocWithZone:[[[pipeline contentCacheForLastAddress] contentZone] nsZone]] init];
    
    return self;
}

- (void)dealloc;
{
    [(id <NSObject>)lastImage release];
    [omniImage release];
    [super dealloc];
}

// These methods are called by our subclasses

- (void)addOmniImageToPipelineIfIncrementalDisplayIsDesired;
{
    if (![pipeline contextObjectForKey:@"DisableIncrementalDisplay"])
        [self addOmniImageToPipeline];
}

- (void)addOmniImageToPipeline;
{
    [pipeline addContent:omniImage];
    [pipeline cacheContent];
    [pipeline startProcessingContent];
}

- (void)setImage:(NSImage *)anImage;
{
    if (lastImage != anImage) {
	[(id)lastImage release];
	lastImage = [(id)anImage retain];
    }
}

- (void)setImageSize:(NSSize)newImageSize;
{
    [omniImage setSize:newImageSize];
}

- (BOOL)drawIntervalReached;
{
    return [NSDate timeIntervalSinceReferenceDate] - lastDrawTimeInterval >
           drawInterval;
}

- (void)flushImage;
{
    NSTimeInterval nowTimeInterval;

    needUpdate = YES;

    nowTimeInterval = [NSDate timeIntervalSinceReferenceDate];
    if (nowTimeInterval - lastDrawTimeInterval > drawInterval) {
        lastDrawTimeInterval = nowTimeInterval;
        [self updateImage:lastImage];
    }
}

- (void)updateImage:(NSImage *)anImage;
{
    needUpdate = NO;
    [self setImage:anImage];
    [omniImage updateImage:anImage];
}

//

- (void)fillGammaCorrectionTable:(OFByte[256])gammaCorrectionTable withSamplesOfGamma:(double)gamma;
{
    return [OIImage fillGammaCorrectionTable:gammaCorrectionTable withSamplesOfGamma:gamma];
}

// OWProcessor subclass

- (void)processBegin;
{
    NSUserDefaults *userDefaults;

    [super processBegin];
    
    userDefaults = [NSUserDefaults standardUserDefaults];

    if ([pipeline contextObjectForKey:@"DisableIncrementalDisplay"])
	drawInterval = 1e+10;
    else
	drawInterval = [userDefaults floatForKey:@"OIImageProcessorDrawInterval"];
    OIImageProcessorCheckTimeEveryNRows = [userDefaults integerForKey:@"OIImageProcessorCheckTimeEveryNRows"];
    lastDrawTimeInterval = [NSDate timeIntervalSinceReferenceDate];
}

- (void)processEnd;
{
    if (needUpdate)
	[self updateImage:lastImage];
    if ([pipeline contextObjectForKey:@"DisableIncrementalDisplay"])
	[self addOmniImageToPipeline];
    [super processEnd];
}

- (void)processAbort;
{
    [omniImage abortImage];
    [super processAbort];
}

//

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary setObject:omniImage forKey:@"omniImage"];
    [debugDictionary setObject:[NSDate dateWithTimeIntervalSinceReferenceDate:lastDrawTimeInterval] forKey:@"lastDrawTimeInterval"];

    return debugDictionary;
}

@end
