// Copyright 1999-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OIF/NSBitmapImageRep-OIExtensions.h,v 1.4 2001/02/15 15:11:47 kc Exp $

#import <AppKit/NSBitmapImageRep.h>

@interface NSBitmapImageRep (OIExtensions)

#if 0
/* Low-efficiency methods for extracting single pixels from an NSBitmapImageRep */

/* slow, but general */
- (NSColor *)colorOfPixel:(unsigned)x :(unsigned)y;

/* faster, but forces extra restrictions on image content */
- (void)getRGBA:(unsigned int *)c forPixelAtX:(unsigned)x y:(unsigned)y scaledToBPS:(int)bps;

/* Another possibility would be:
- (NSDictionary *)componentsOfPixelsForRow:(int)row colorSpaceName:(NSString *)foo scaledToBPS:(int)bps;

where the dictionary would have keys "red", "cyan", "saturation", "alpha", whatever, and values which are NSDatas containing a zillion ints, or possibly a special wrapper object which wraps array(s) of integers efficiently. This would be fast *and* not suck too much. */

#endif

@end
