// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OIF/OIImage.h,v 1.18 2001/02/15 15:11:49 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSArray, NSData, NSLock, NSMutableArray;
@class NSImage;

#import <Foundation/NSGeometry.h> // For NSSize
#import <OmniFoundation/OFByte.h>
#import <OmniFoundation/OFWeakRetainProtocol.h>
#import <OWF/OWContentProtocol.h>
#import <OIF/OIImageObserverProtocol.h>
#import <OIF/OIImageSourceDataProtocol.h>

@interface OIImage : OWAbstractContent
{
    BOOL haveSize;
    NSSize imageSize;
    NSImage *nsImage;
    NSLock *nsImageLock;

    NSMutableArray *_observers;
    NSLock *observersLock;
    id <OIImageSourceData> sourceData;
}

+ (OWContentType *)contentType;

// Gamma utility methods

+ (double)sourceGamma;
    // Standard is sRGB, approximately 2.2
+ (double)targetGamma;
    // Standard Macintosh monitors use 1.8
+ (double)gammaCorrection;
    // +sourceGamma / +targetGamma
+ (void)fillGammaCorrectionTable:(OFByte[256])gammaCorrectionTable withSamplesOfGamma:(double)gamma;

// Image API

- (BOOL)hasSize;
- (NSSize)size;
- (void)setSize:(NSSize)newSize;
- (NSImage *)image;

- (void)updateImage:(NSImage *)anImage;
- (void)abortImage;

- (void)startAnimation;
- (void)stopAnimation;

- (NSArray *)observers;
    // Returns a snapshot of the array of observers
- (unsigned int)observerCount;
    // Returns the number of observers for this image (more efficient than [[self observers] count])

- (void)addObserver:(id <OIImageObserver, OFWeakRetain>)anObserver;
    // Subscribed anObserver to receive messages described in the OIImageObserver protocol.  The new observer is  retained.  The new observer is responsible for unsubscribing itself so that it can eventually be deallocated.

- (void)removeObserver:(id <OIImageObserver, OFWeakRetain>)anObserver;
    // Unsubscribes anObserver such that it will not receive the messages described in the OIImageObserver protocol and is no longer retained by the image.

- (void)setSourceData:(id <OIImageSourceData>)imageSourceData;

@end
