// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimation.h,v 1.13 2001/09/13 20:30:13 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSLock;
@class NSMutableArray;
@class OIAnimationInstance;
@class OIAnimationFrame;
@class OIImage;

#define OIAnimationInfiniteLoopCount ((unsigned int)~0)

@interface OIAnimation : OWAbstractContent
{
    id <OWContent> sourceContent;
    NSMutableArray *frames;
    unsigned int loopCount;
    NSMutableArray *waitingInstances;
    BOOL haveAllFrames;
    NSLock *lock;
}

- initWithSourceContent:(id <OWContent>)someContent loopCount:(unsigned int)aLoopCount;

- (id <OWContent>)sourceContent;

- (void)addFrame:(OIAnimationFrame *)frame;
- (void)endFrames;

- (OIImage *)animationInstance; // each call returns new instance 

- (unsigned int)loopCount;
- (void)animationInstance:(OIAnimationInstance *)instance wantsFrame:(unsigned int)frameNumber;

@end
