// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OIF/OIAnimationInstance.h,v 1.16 2001/09/13 20:30:13 kc Exp $

#import <OIF/OIImage.h>

@class OFScheduledEvent;
@class OIAnimation, OIAnimationFrame;

#import <OmniFoundation/OFWeakRetainConcreteImplementation.h>

@interface OIAnimationInstance : OIImage <OIImageObserver, OFWeakRetain>
{
    OIAnimation *animation;
    OIAnimationFrame *frame;
    unsigned int remainingLoops;
    unsigned int nextFrame;
    OFScheduledEvent *nextFrameEvent;
    NSLock *nextFrameEventLock;

    OFWeakRetainConcreteImplementation_IVARS;
}

- (id)initWithAnimation:(OIAnimation *)animation;

// Called by the animation, possibly from another thread.
- (void)animationEnded;
- (void)animationReceivedFrame:(OIAnimationFrame *)aFrame;

OFWeakRetainConcreteImplementation_INTERFACE

@end
