// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIBitmapImageProcessor.h,v 1.10 2001/10/15 23:44:15 wiml Exp $

#import <OIF/OIImageProcessor.h>

@class NSBitmapImageRep;

#define OIBitmapImageProcessor_MaxPlanes 5

@interface OIBitmapImageProcessor : OIImageProcessor
{
    // output storage
    unsigned int numberOfPlanes;
    BOOL isPlanar;
    unsigned char *imageDataPlanes[OIBitmapImageProcessor_MaxPlanes];
    NSBitmapImageRep *resultImageRep;
    NSData *embeddedICCProfile;
}

- (void)setImageRep:(NSBitmapImageRep *)imageRep;
- (NSBitmapImageRep *)imageRep;

- (void)setEmbeddedICCProfile:(NSData *)colorProfile;

- (unsigned char **)imageDataPlanes;

@end
