// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OIF/OIImage.h,v 1.23 2001/09/13 20:30:13 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSArray, NSData, NSLock, NSMutableArray;
@class NSImage;

#import <Foundation/NSGeometry.h> // For NSSize
#import <OmniFoundation/OFByte.h>
#import <OmniFoundation/OFWeakRetainProtocol.h>
#import <OWF/OWContentProtocol.h>
#import <OIF/OIImageObserverProtocol.h>

@interface OIImage : OWAbstractContent
{
    BOOL haveSize;
    NSSize imageSize;
    NSImage *nsImage;
    NSLock *nsImageLock;

    NSMutableArray *_observers;
    NSLock *observersLock;
    
    NSData *_pixelData;
    id <OWContent> _sourceContent;
}

+ (OWContentType *)contentType;

// Gamma utility methods

+ (double)sourceGamma;
    // Standard is sRGB, approximately 2.2
+ (double)targetGamma;
    // Standard Macintosh monitors use 1.8
+ (double)gammaCorrection;
    // +sourceGamma / +targetGamma
+ (void)fillGammaCorrectionTable:(OFByte[256])gammaCorrectionTable withSamplesOfGamma:(double)gamma;

// Image API

- (id)initWithSourceContent:(id <OWContent>)sourceContent;
    // Designated initializer
- (id <OWContent>)sourceContent;

- (BOOL)hasSize;
- (NSSize)size;
- (void)setSize:(NSSize)newSize;
- (NSImage *)image;

- (void)updateImage:(NSImage *)anImage;
- (void)abortImage;

- (void)startAnimation;
- (void)stopAnimation;

- (NSArray *)observers;
    // Returns a snapshot of the array of observers
- (unsigned int)observerCount;
    // Returns the number of observers for this image (more efficient than [[self observers] count])

- (void)addObserver:(id <OIImageObserver, OFWeakRetain>)anObserver;
    // Subscribed anObserver to receive messages described in the OIImageObserver protocol.  The new observer is  retained.  The new observer is responsible for unsubscribing itself so that it can eventually be deallocated.

- (void)removeObserver:(id <OIImageObserver, OFWeakRetain>)anObserver;
    // Unsubscribes anObserver such that it will not receive the messages described in the OIImageObserver protocol and is no longer retained by the image.

- (void)setPixelData:(NSData *)newPixelData;
    // This data provides a pointer to the image backing store so you can render directly into it.
    
@end
