// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWDataStreamScanner.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWDataStreamCursor.h>
#import <OWF/OWDataStream.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWDataStreamScanner.m,v 1.9 2000/04/05 23:55:07 toon Exp $")

@interface OWDataStreamScanner (Private)
@end

static unsigned int OWDataStreamScannerMinimumBufferLength = OWDataStreamBuffer_BufferedDataLength * 2;
// The buffer length must be at least twice the size of an OWDataStream's buffer because we might get a whole buffer, and need to pad a single byte character set out to unicode.

@implementation OWDataStreamScanner

- initWithCursor:(OWDataStreamCursor *)aStreamCursor bufferLength:(unsigned int)aBufferLength;
{
    if (!(self = [super init]))
	return nil;

    streamCursor = [aStreamCursor retain];
    bufferLength = aBufferLength;

    if (bufferLength < OWDataStreamScannerMinimumBufferLength)
        bufferLength = OWDataStreamScannerMinimumBufferLength;

    buffer = (unichar *)NSZoneMalloc([self zone], bufferLength * sizeof(unichar));

    return self;
}

- initWithCursor:(OWDataStreamCursor *)aStreamCursor;
{
    return [self initWithCursor:aStreamCursor bufferLength:0];
}

- (void)dealloc;
{
    [streamCursor release];
    NSZoneFree(NSZoneFromPointer(buffer), buffer);
    [super dealloc];
}

// OWScanner subclass

- (BOOL)fetchMoreData;
{
    unsigned int length;
    void *underlyingBuffer;
    unsigned char *sourcePointer;
    unichar *destinationPointer;

    if ([streamCursor stringDecoder])
        return [self fetchMoreDataFromString:[streamCursor readString]];

    switch ([streamCursor stringEncoding]) {
        case NSASCIIStringEncoding:
        case NSISOLatin1StringEncoding:
            length = [streamCursor readUnderlyingBuffer:&underlyingBuffer];

            // Now, go through the buffer distributing those bytes (casting char to unichar, implicitly padding the top byte).
            sourcePointer = underlyingBuffer + length - 1;
            destinationPointer = buffer + length - 1;
            while (destinationPointer >= buffer) {
                *destinationPointer-- = (unichar)*sourcePointer--;
            }
            return [self fetchMoreDataFromCharacters:buffer length:length freeWhenDone:NO];
        case NSUnicodeStringEncoding:
            length = [streamCursor readUnderlyingBuffer:&underlyingBuffer];
            return [self fetchMoreDataFromCharacters:underlyingBuffer length:length freeWhenDone:NO];
        default:
            return [self fetchMoreDataFromString:[streamCursor readString]];
    }
}

- (void)setScanLocation:(unsigned int)aLocation;
{
    if (aLocation >= inputStringPosition) {
	unsigned int inputLocation = aLocation - inputStringPosition;

        if (inputBuffer + inputLocation < scanEnd) {
            scanLocation = inputBuffer + inputLocation;
        } else {
	    scanEnd = inputBuffer;
	    scanLocation = scanEnd;
	    [streamCursor skipBytes:inputLocation - (scanEnd - inputBuffer)];
	    inputStringPosition = aLocation;
	}
    } else {
	scanEnd = inputBuffer;
	scanLocation = scanEnd;
	[streamCursor seekToOffset:aLocation fromPosition:OWCursorSeekFromStart];
	inputStringPosition = aLocation;
    }
}

- (void)skipCharacters:(int)anOffset;
{
    if (scanLocation + anOffset < inputBuffer) {
	[self setScanLocation:inputStringPosition + (scanLocation - inputBuffer) + anOffset];
	return;
    }
    scanLocation += anOffset;
    if (scanLocation >= scanEnd) {
	[streamCursor skipBytes:scanLocation - scanEnd];
	inputStringPosition += (scanLocation - inputBuffer);
	scanEnd = inputBuffer;
	scanLocation = scanEnd;
    }
}

@end
