// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWObjectTree.h,v 1.5 2000/03/25 06:44:33 wjs Exp $

#import <OWF/OWObjectTreeNode.h>
#import <OWF/OWContentProtocol.h>
#import <OmniFoundation/OFSimpleLock.h>

@interface OWObjectTree : OWObjectTreeNode <OWContent>
{
    OWContentType *nonretainedContentType;
    OWContentInfo *contentInfo;
    OFSimpleLockType mutex;
}

- initWithRepresentedObject:(NSObject *)object;

- (void)setContentType:(OWContentType *)aType;
- (void)setContentTypeString:(NSString *)aString;

@end

// Only for use by OWObjectTreeNode
@interface OWObjectTree (lockAccess)
- (OFSimpleLockType *)mutex;
@end
