// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentInfo.h,v 1.18 2000/04/06 12:21:41 wjs Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/OFMessageQueuePriorityProtocol.h>

#import <Foundation/NSDate.h> // For NSTimeInterval

@class NSArray, NSCountedSet, NSMutableArray, NSLock;
@class OWAddress, OWTask;

#import <OWF/OWAddressProtocol.h>
#import <OWF/OWContentProtocol.h>

extern NSString *OWOrphanTaskHeaderName;

@interface OWContentInfo : OFObject
{
    id <OWContent> nonretainedContent;

    NSMutableArray *tasks;
    NSLock *tasksLock;

    NSMutableArray *childTasks;
    NSLock *childTasksLock;

    NSMutableArray *activeChildTasks;
    NSLock *activeChildTasksLock;

    NSString *typeString;
    id <OWAddress> address;
    NSLock *addressLock;

    struct {
        unsigned int wasActiveOnLastCheck:1;
        unsigned int isHeader:1;
    } flags;
    NSLock *flagsLock;
    int workToBeDoneIncludingChildren;

    unsigned int priority, maximumSimultaneousThreadsInGroup;

    /* This is used by a OWContentInfo category in the OmniHTML framework. */
    id scriptContext;
}

+ (OWContentInfo *)topLevelActiveContentInfo;
+ (OWContentInfo *)headerContentInfoWithName:(NSString *)name;
+ (OWContentInfo *)orphanParentContentInfo;

+ (NSArray *)allActiveTasks;

- initWithContent:(id <OWContent>)aContent;
- initWithContent:(id <OWContent>)aContent typeString:(NSString *)aType;

// Actions
- (void)deepFlushContentCache;

// Content
- (id <OWContent>)content;
- (void)nullifyContent;

// Info
- (NSString *)typeString;

- (void)setAddress:(id <OWAddress>)newAddress;
- (id <OWAddress>)address;

// Inspecting
- (void)tellInspectorPipelineTreeDidChange;

// Pipelines
    // Pipelines that have our content as their last content.  We may have multiple pipelines in the case where, say, a single image is in two browser windows.
- (NSArray *)tasks;
- (void)addTask:(OWTask *)aTask;
    // Only called by -[OWTask pipelineBuilt].
- (void)removeTask:(OWTask *)aTask;
    // Only called by -[OWTask pipelineBuilt].

// Children tasks
    // Pipelines whose OWTarget is a child element of our OWContent somehow. For example, if we are an HTML file we may have some pipelines to inline images as children.  Frames have pipelines to HTML views as children.  Note that content can only contain targets, not content.  (However, most times these targets will have pointers to some content.)
- (void)addChildTask:(OWTask *)aTask;
    // Only can be called by -[OWTask setParentContentInfo:].
- (void)removeChildTask:(OWTask *)aTask;
    // Only can be called by -[OWTask setParentContentInfo:].
- (NSArray *)childTasks;
- (OWTask *)childTaskAtIndex:(unsigned int)childIndex;
- (unsigned int)childTasksCount;
- (int)workDoneByChildTasks;
- (int)workToBeDoneByChildTasks;
- (void)calculateDeadPipelines:(unsigned int *)deadPipelines totalPipelines:(unsigned int *)totalPipelines;

// Active tree
    // A pure subset of children tasks, we also track tasks that are active or any descendents that are active.
- (BOOL)treeHasActiveChildren;
- (void)addActiveChildTask:(OWTask *)aTask;
- (void)removeActiveChildTask:(OWTask *)aTask;
- (NSArray *)activeChildTasks;
- (OWTask *)activeChildTaskAtIndex:(unsigned int)childIndex;
- (unsigned int)activeChildTasksCount;
- (void)abortActiveChildTasks;
- (NSTimeInterval)estimatedRemainingTreeTimeIntervalForActiveChildTasks;

// OFMessageQueue protocol helpers
- (unsigned int)baseTaskPriority;
- (unsigned int)taskGroup;
- (unsigned int)taskMaximumSimultaneousThreadsInGroup;

@end
