// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWHeaderDictionary.h,v 1.7 2000/01/19 23:36:04 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSCharacterSet, NSLock;
@class OFDataCursor, OFMultiValueDictionary;
@class ONSocketStream;
@class OWContentType, OWDataStreamCursor;

@interface OWHeaderDictionary : OFObject
{
    OFMultiValueDictionary *headerDictionary;
    NSLock *contentTypeLock;
    OWContentType *contentType;
    OFMultiValueDictionary *contentTypeParameters;
}

- (NSArray *)stringArrayForKey:(NSString *)aKey;
- (NSString *)firstStringForKey:(NSString *)aKey;
- (NSString *)lastStringForKey:(NSString *)aKey;
- (void)addString:(NSString *)aString forKey:(NSString *)aKey;

- (void)parseRFC822Header:(NSString *)aHeader;
- (void)readRFC822HeadersFromDataCursor:(OFDataCursor *)aCursor;
- (void)readRFC822HeadersFromCursor:(OWDataStreamCursor *)aCursor;
- (void)readRFC822HeadersFromSocketStream:(ONSocketStream *)aSocketStream;

- (OWContentType *)contentType;
- (OFMultiValueDictionary *)contentTypeParameters;
- (OWContentType *)contentEncoding;

// Parses a parameterized header such as Content-Type or Refresh.  Returns the simple value, and places parameters into the dictionary.  On error returns what it has so far (doesn't raise an exception).  okSet is the set of characters which can occur in an unquoted value.
+ (NSString *)parseParameterizedHeader:(NSString *)aHeader intoDictionary:(OFMultiValueDictionary *)parameters valueChars:(NSCharacterSet *)okSet;

@end

@interface OWHeaderDictionary (Debugging)
+ (void)setDebug:(BOOL)debugMode;
@end
