// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWURLFileProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentCache.h>
#import <OWF/OWContentType.h>
#import <OWF/OWAddress.h>
#import <OWF/OWDataStreamProcessor.h>
#import <OWF/OWDataStreamCursor.h>
#import <OWF/OWPipeline.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWURLFileProcessor.m,v 1.3 2000/03/25 06:44:37 wjs Exp $")

static OWContentType *sourceContentType;

@implementation OWURLFileProcessor

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    sourceContentType = [OWContentType contentTypeForString:@"application/x-url"];
}

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:sourceContentType toContentType:[OWContentType wildcardContentType] cost:1.0];
}

+ (OWContentType *)sourceContentType;
{
    return sourceContentType;
}

- (void)process;
{
    OWAddress *anAddress;

    anAddress = [OWAddress addressForDirtyString:[dataCursor readString]];
    [pipeline addContent:anAddress];
    [pipeline startProcessingContent];
}

@end
