// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWFTPProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWAddress.h>
#import <OWF/OWFTPSession.h>
#import <OWF/OWSourceProcessor.h>
#import <OWF/OWURL.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/FTP.subproj/OWFTPProcessor.m,v 1.4 2000/03/25 06:44:38 wjs Exp $")

@implementation OWFTPProcessor

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"ftp"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

- initWithPipeline:(OWPipeline *)aPipeline;
{
    if (![super initWithPipeline:aPipeline])
	return nil;

    ftpAddress = [(OWAddress *)[pipeline lastContent] retain];

    return self;
}

- (void)dealloc;
{
    [ftpAddress release];
    [super dealloc];
}

- (void)process;
{
    ftpSession = [OWFTPSession ftpSessionForAddress:ftpAddress];
    [ftpSession fetchForProcessor:self inPipeline:pipeline];
    ftpSession = nil;
}

- (void)abortProcessing;
{
    [ftpSession abortOperation];
    ftpSession = nil;
    [super abortProcessing];
}

@end
