// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWCookie.h,v 1.10 2000/03/25 06:44:39 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDate;
@class OWHeaderDictionary, OWURL;

#import <OWF/OWAddressProtocol.h>

@interface OWCookie : OFObject
{
    NSString *domain;
    NSString *path;
    NSString *name;
    NSString *value;
    NSDate *expirationDate;
    BOOL secure;
}

+ (void)readDefaults;
+ (void)deleteCookies;
+ (void)saveCookies;
+ (NSDictionary *)registeredCookies;
+ (NSArray *)cookiesForURL:(OWURL *)url;
+ (void)registerCookiesFromURL:(OWURL *)url headerDictionary:(OWHeaderDictionary *)headerDictionary;

+ (OWCookie *)cookieWithDomain:(NSString *)aDomain path:(NSString *)aPath name:(NSString *)aName value:(NSString *)aValue expirationDate:(NSDate *)aDate secure:(BOOL)isSecure;
+ (OWCookie *)cookieWithDomain:(NSString *)aDomain path:(NSString *)aPath name:(NSString *)aName dictionary:(NSDictionary *)aDictionary;
+ (OWCookie *)cookieFromHeaderValue:(NSString *)headerValue defaultDomain:(NSString *)defaultDomain defaultPath:(NSString *)defaultPath;
+ (void)deleteDomain:(NSString *)aDomain path:(NSString *)aPath cookie:(OWCookie *)aCookie;
+ (void)disableDomain:(NSString *)aDomain;

- (NSString *)domain;
- (NSString *)path;
- (NSString *)name;
- (NSString *)value;
- (NSDate *)expirationDate;
- (BOOL)isExpired;
- (BOOL)secure;
- (BOOL)appliesToAddress:(id <OWAddress>)anAddress;
- (BOOL)appliesToHostname:(NSString *)aHostname path:(NSString *)aPath;
- (BOOL)appliesToPath:(NSString *)fetchPath;

- (void)registerCookie;

- (NSMutableDictionary *)saveDictionary;

@end

#import <OWF/FrameworkDefines.h>

OWF_EXTERN NSString *OWCookieImmunizedDomainPath;
    // If a domain has a cookie with this path, then the user has requested that cookies for this domain be silently ignored
