// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWHTMLToSGMLObjects.h,v 1.8 2000/03/25 06:44:40 wjs Exp $

#import <OWF/OWDataStreamProcessor.h>

@class OFTrie;
@class OWDataStreamCursor, OWDataStreamScanner, OWObjectStream, OWSGMLDTD;

#import <OWF/OWStringDecoderProtocol.h>

@interface OWHTMLToSGMLObjects : OWDataStreamProcessor
{
    OWObjectStream *objectStream;
    OWDataStreamScanner *scanner;
    OFTrie *tagTrie;

    struct {
        unsigned int netscapeCompatibleComments:1;
        unsigned int netscapeCompatibleNewlineAfterEntity:1;
        // ISO 8879 9.4.5 [61] 353:1 says that newlines following an entity should be ignored.  Unfortunately, Netscape preserves them.
        unsigned int netscapeCompatibleNonterminatedEntities:1;
        // Netscape does not require proper termination of entities.
    } flags;
}

+ (id <OWStringDecoder>)stringDecoder;
+ (NSStringEncoding)stringEncoding;
+ (void)setStringDecoderClass:(Class)aClass;
+ (Class)stringDecoderClass;

+ (BOOL)recognizesEntityNamed:(NSString *)entityName;
    // Returns YES if the named entity is known.

- initWithDataStreamCursor:(OWDataStreamCursor *)aDataStreamCursor forDTD:(OWSGMLDTD *)aDTD;
- initWithDataStreamCursor:(OWDataStreamCursor *)aDataStreamCursor;
- (OWObjectStream *)outputStream;

@end
