// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWAbstractObjectStream.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWObjectStreamCursor.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWAbstractObjectStream.m,v 1.6 2000/04/05 23:55:06 toon Exp $")

@implementation OWAbstractObjectStream

- (void)writeObject:(id)anObject
{
    [self doesNotRecognizeSelector:_cmd];
}

- (void)writeFormat:(NSString *)formatString, ...;
{
    va_list argList;
    NSString *string;

    va_start(argList, formatString);
    string = [[NSString alloc] initWithFormat:formatString arguments:argList];
    [self writeObject:string];
    va_end(argList);
    [string release];
}


- (id)objectAtIndex:(unsigned int)index;
{
    [self doesNotRecognizeSelector:_cmd];
    return nil;
}

- (id)objectAtIndex:(unsigned int)index withHint:(void **)hint;
{
    return [self objectAtIndex:index];
}

- (unsigned int)objectCount;
{
    [self doesNotRecognizeSelector:_cmd];
    return 0;
}


- (id)newCursor;
{
    return [[[OWObjectStreamCursor alloc] initForObjectStream:self] autorelease];
}


@end
