// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWCursor.h,v 1.8 2000/03/25 06:44:31 wjs Exp $

#import <OWF/OWAbstractContent.h>

@class NSException;

typedef enum {
    OWCursorSeekFromCurrent,
    OWCursorSeekFromEnd,
    OWCursorSeekFromStart
} OWCursorSeekPosition;

@interface OWCursor : OWAbstractContent
{
    NSException *abortException;
}

- initFromCursor:(id)aCursor;
- (id)newCursor;

- (unsigned int)seekToOffset:(int)offset fromPosition:(OWCursorSeekPosition)position;
- (void)abortWithException:(NSException *)anException;
- (void)abort;
    // Calls -abortWithException: passing userAbortException as the exception

@end
