// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWConversionPathElement.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>
#import <OWF/OWContentTypeLink.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWConversionPathElement.m,v 1.6 2000/03/25 06:44:35 wjs Exp $")

@implementation OWConversionPathElement

+ (OWConversionPathElement *)elementWithParent:(OWConversionPathElement *)anElement usingLink:(OWContentTypeLink *)aLink targetContentType:(OWContentType *)aType;
{
    return [[[self alloc] initWithParentElement:anElement usingLink:aLink targetContentType:aType] autorelease];
}

- initWithParentElement:(OWConversionPathElement *)anElement usingLink:(OWContentTypeLink *)aLink targetContentType:(OWContentType *)aType;
{
    if (![super init])
	return nil;

    parentElement = anElement;
    link = aLink;
    targetContentType = aType;
    
    return self;
}

- (OWConversionPathElement *)parentElement;
{
    return parentElement;
}

- (OWContentTypeLink *)link;
{
    return link;
}

- (OWContentType *)targetContentType;
{
    return targetContentType;
}

- (OWContentTypeLink *)rootLink;
{
    OWContentTypeLink *parentRootLink;

    parentRootLink = [parentElement rootLink];
    return parentRootLink ? parentRootLink : link;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (parentElement)
	[debugDictionary setObject:parentElement forKey:@"parentElement"];
    if (link)
	[debugDictionary setObject:link forKey:@"link"];
    if (targetContentType)
	[debugDictionary setObject:targetContentType forKey:@"targetContentType"];
    return debugDictionary;
}

@end
