// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWCookie.h,v 1.13 2000/06/28 02:45:29 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/OFDataBuffer.h>

@class NSDate;

#import <OWF/OWAddressProtocol.h>
#import <OWF/FrameworkDefines.h>
#import <CoreFoundation/CFPropertyList.h>

OWF_EXTERN NSString *OWCookieGlobalPath;

@interface OWCookie : OFObject
{
    NSString *_domain;
    NSString *_path;
    NSString *_name;
    NSString *_value;
    NSDate   *_expirationDate;
    BOOL      _secure;
}

- initWithDomain:(NSString *)aDomain path:(NSString *)aPath name:(NSString *)aName value:(NSString *)aValue expirationDate:(NSDate *)aDate secure:(BOOL)isSecure;
- initWithDomain: (NSString *) aDomain dictionary: (NSDictionary *) aDictionary;

- (NSString *)domain;
- (NSString *)path;
- (NSString *)name;
- (NSString *)value;
- (NSDate *)expirationDate;
- (BOOL)secure;

// Cookies without expiration dates last until the end of the session.
// Cookies with expiration dates in the past expire immediately.
// So expiration is not as simple as it might be expected.
- (BOOL) isExpired;

- (BOOL)appliesToAddress:(id <OWAddress>)anAddress;
- (BOOL)appliesToHostname:(NSString *)aHostname path:(NSString *)aPath;
- (BOOL)appliesToPath:(NSString *)fetchPath;

//
// Saving
//
- (void) appendXML: (OFDataBuffer *) xmlBuffer;

@end



