// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWCookieDomain.h,v 1.5 2000/06/28 02:03:06 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/OFDataBuffer.h>
#import <OWF/FrameworkDefines.h>

@class NSArray, NSLock, NSMutableArray;
@class OWCookie, OWCookiePath, OWHeaderDictionary, OWPipeline, OWURL;

typedef enum _OWCookieDomainBehavior {
    OWCookieDomainDefaultBehavior = 0,
    OWCookieDomainPromptBehavior  = 1, // i.e., ask the delegate
    OWCookieDomainAcceptBehavior  = 2,
    OWCookieDomainRejectBehavior  = 3,
} OWCookieDomainBehavior;

typedef enum _OWCookiePromptResponse {
    OWCookiePromptAcceptResponse,
    OWCookiePromptRejectResponse,
    OWCookiePromptAlwaysAcceptResponse,
    OWCookiePromptAlwaysRejectResponse,
} OWCookiePromptResponse;


OWF_EXTERN BOOL OWCookiesDebug;
OWF_EXTERN NSString *OWSetCookieHeader;

@interface OWCookieDomain : OFObject
{
    NSLock                 *_promptLock;
    NSString               *_name;
    NSMutableArray         *_cookiePaths;
    OWCookieDomainBehavior  _behavior;
}

+ (void)readDefaults;

+ (void) registerCookiesFromPipeline: (OWPipeline *) pipeline
                         headerValue: (NSString *) headerValue;
+ (void)registerCookiesFromPipeline: (OWPipeline *) pipeline
                   headerDictionary: (OWHeaderDictionary *)headerDictionary;
+ (NSArray *)cookiesForURL:(OWURL *)url;

+ (void) didChange;

+ (NSArray *) allDomains;
+ (OWCookieDomain *) domainNamed: (NSString *) name;
+ (void) deleteDomain: (OWCookieDomain *) domain;
+ (void) deleteCookie: (OWCookie *) cookie;

+ (void) setDelegate: (id) delegate;
+ (id) delegate;

+ (OWCookieDomainBehavior) defaultBehavior;
+ (void) setDefaultBehavior: (OWCookieDomainBehavior) behavior;

- (NSString *) name;

- (OWCookieDomainBehavior) internalBehavior;
- (void) setInternalBehavior: (OWCookieDomainBehavior) behavior;

- (OWCookieDomainBehavior) behavior;

- (NSArray *) paths;
- (OWCookiePath *) pathNamed: (NSString *) name;

//
// Saving
//
- (void) appendXML: (OFDataBuffer *) xmlBuffer;

//
// Convenience methods that find the right path.
//
- (void) addCookie: (OWCookie *) cookie;
- (void) removeCookie: (OWCookie *) cookie;
- (NSArray *) cookies;

@end


@interface NSObject (OWCookieDomainDelegate)
+ (OWCookiePromptResponse) cookieDomain: (OWCookieDomain *) domain
                promptResponseForCookie: (OWCookie *) cookie
                           fromPipeline: (OWPipeline *) pipeline;
@end


OWF_EXTERN NSString *OWCookiesChangedNotification;
    // Posted when cookie data has changed.
