// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWHTTPSessionQueue.h,v 1.10 2000/03/04 01:57:00 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWAddress;
@class NSMutableArray;
@class NSMutableSet;
@class NSLock;
@class OWHTTPProcessor;
@class OWHTTPSession;
@class OFDatedMutableDictionary;

@interface OWHTTPSessionQueue : OFObject
{
    OWAddress *address;
    NSMutableArray *idleSessions;
    NSMutableArray *sessions;
    NSMutableArray *queuedProcessors;
    NSMutableSet *abortedProcessors;
    NSLock *lock;
    struct {
        unsigned int serverUnderstandsPipelinedRequests:1;
        unsigned int serverCannotHandlePipelinedRequestsReliably:1;
    } flags;
}

+ (OWHTTPSessionQueue *)httpSessionQueueForAddress:(OWAddress *)anAddress;
+ (NSString *)cacheKeyForSessionQueueForAddress:(OWAddress *)anAddress;
+ (Class)sessionClass;
+ (OFDatedMutableDictionary *)cache;
+ (unsigned int)maximumSessionsPerServer;

- initWithAddress:(OWAddress *)anAddress;
- (BOOL)queueProcessor:(OWHTTPProcessor *)aProcessor;
- (void)runSession;
- (void)abortProcessingForProcessor:(OWHTTPProcessor *)aProcessor;

- (OWHTTPProcessor *)nextProcessor;
- (BOOL)sessionIsIdle:(OWHTTPSession *)session;
- (void)session:(OWHTTPSession *)session hasStatusString:(NSString *)statusString;

- (BOOL)queueEmptyAndAllSessionsIdle;
- (NSString *)queueKey;

- (void)setServerUnderstandsPipelinedRequests;
- (BOOL)serverUnderstandsPipelinedRequests;
- (void)setServerCannotHandlePipelinedRequestsReliably;
- (BOOL)shouldPipelineRequests;
- (unsigned int)maximumNumberOfRequestsToPipeline;

@end
