// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLTag.h,v 1.8 2000/03/25 06:44:41 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class OWSGMLTagType;

#import <OWF/OWSGMLTokenProtocol.h>

#define OWSGMLTagMaxAttributes 32

@interface OWSGMLTag : OFObject <OWSGMLToken>
{
@public
    OWSGMLTokenType tokenType;
    OWSGMLTagType *nonretainedTagType;
    NSString *attributes[OWSGMLTagMaxAttributes];
}

+ (OWSGMLTag *)tagWithTokenType:(OWSGMLTokenType)aType tagType:(OWSGMLTagType *)aTagType;
+ (OWSGMLTag *)startTagOfType:(OWSGMLTagType *)aTagType;
+ (OWSGMLTag *)endTagOfType:(OWSGMLTagType *)aTagType;

- initWithTokenType:(OWSGMLTokenType)aTokenType tagType:(OWSGMLTagType *)aTagType;

- (OWSGMLTagType *)tagType;
- (NSString *)name;
- (NSDictionary *)attributes;

- (BOOL)isNamed:(NSString *)aName;

- (void)setValue:(NSString *)value atIndex:(unsigned int)index;
- (NSString *)valueForAttribute:(NSString *)attributeName;
- (BOOL)attributePresent:(NSString *)attributeName;

- (NSString *)valueForAttributeAtIndex:(unsigned int)index;
- (BOOL)attributePresentAtIndex:(unsigned int)index;

@end

#import <Foundation/NSString.h>
#import <OmniBase/assertions.h>
#import <OmniFoundation/OFNull.h>

static inline OWSGMLTagType *sgmlTagType(OWSGMLTag *tag)
{
    return tag->nonretainedTagType;
}

static inline OWSGMLTokenType sgmlTagTokenType(OWSGMLTag *tag)
{
    return tag->tokenType;
}

static inline BOOL sgmlTagAttributePresentAtIndex(OWSGMLTag *tag, unsigned int index)
{
    OBPRECONDITION(index < OWSGMLTagMaxAttributes);
    return tag->attributes[index] != nil;
}

static inline NSString *sgmlTagValueForAttributeAtIndex(OWSGMLTag *tag, unsigned int index)
{
    NSString *value;

    OBPRECONDITION(index < OWSGMLTagMaxAttributes);
    value = tag->attributes[index];
    if (!value || value == OFNullStringObject)
        return nil;
    return value;
}

static inline int sgmlTagIntValueForAttributeAtIndexWithDefaultValue(OWSGMLTag *tag, unsigned int index, int defaultValue)
{
    NSString *value;

    OBPRECONDITION(index < OWSGMLTagMaxAttributes);
    value = sgmlTagValueForAttributeAtIndex(tag, index);
    if (!value || [value length] == 0)
        return defaultValue;
    return [value intValue];
}
