// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWSGMLTag.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/NSString-OWSGMLString.h>
#import <OWF/OWSGMLTagType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLTag.m,v 1.15 2000/04/27 01:19:05 krevis Exp $")

@implementation OWSGMLTag

static NSMutableCharacterSet *requiresQuotesCharacterSet = nil;

+ (void)initialize;
{
    static BOOL initialized = NO;
    
    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    requiresQuotesCharacterSet = [[NSMutableCharacterSet alloc] init];
    [requiresQuotesCharacterSet addCharactersInString:@".-"];
    [requiresQuotesCharacterSet formUnionWithCharacterSet:[NSCharacterSet alphanumericCharacterSet]];
    [requiresQuotesCharacterSet invert];
}

+ (OWSGMLTag *)tagWithTokenType:(OWSGMLTokenType)aType tagType:(OWSGMLTagType *)aTagType;
{
    return [[[self alloc] initWithTokenType:aType tagType:aTagType] autorelease];
}

+ (OWSGMLTag *)startTagOfType:(OWSGMLTagType *)aTagType;
{
    return [self tagWithTokenType:OWSGMLTokenTypeStartTag tagType:aTagType];
}

+ (OWSGMLTag *)endTagOfType:(OWSGMLTagType *)aTagType;
{
    return [self tagWithTokenType:OWSGMLTokenTypeEndTag tagType:aTagType];
}

- initWithTokenType:(OWSGMLTokenType)aTokenType tagType:(OWSGMLTagType *)aTagType
{
    // Not calling [super init] (for efficiency: we know it's unnecessary)
    
    OBASSERT(aTagType != nil);

    tokenType = aTokenType;
    nonretainedTagType = aTagType;
    return self;
}

- (void)dealloc;
{
    unsigned int attributeIndex, attributeCount;

    attributeCount = [[nonretainedTagType attributeNames] count];
    for (attributeIndex = 0; attributeIndex < attributeCount; attributeIndex++)
        [attributes[attributeIndex] release];
    [super dealloc];
}

//

- (OWSGMLTagType *)tagType;
{
    return nonretainedTagType;
}

- (NSString *)name;
{
    return [nonretainedTagType name];
}

- (NSDictionary *)attributes;
{
    NSMutableDictionary *result;
    NSArray *attributeNames;
    unsigned int attributeIndex, attributeCount;

    result = [NSMutableDictionary dictionary];
    attributeNames = [nonretainedTagType attributeNames];
    attributeCount = [attributeNames count];
    for (attributeIndex = 0; attributeIndex < attributeCount; attributeIndex++) {
        NSString *attributeName, *attributeValue;

        attributeName = [attributeNames objectAtIndex:attributeIndex];
        if ((attributeValue = attributes[attributeIndex]))
            [result setObject:attributeValue forKey:attributeName];
    }
    return result;
}

//

- (BOOL)isNamed:(NSString *)aName;
{
    return [[nonretainedTagType name] isEqualToString:aName];
}

//

- (void)setValue:(NSString *)value atIndex:(unsigned int)index;
{
    OBPRECONDITION(index < OWSGMLTagMaxAttributes);

    // WJS 4/6/98: Netscape 4.0 and IE 4.0 both ignore any but the first value for an attribute, so if we already have a value we just return.
    if (attributes[index])
        return;
    attributes[index] = [value retain];
}

- (NSString *)valueForAttribute:(NSString *)attributeName;
{
    unsigned int attributeIndex;

    attributeIndex = [nonretainedTagType indexOfAttribute:attributeName];
    if (attributeIndex == NSNotFound)
        return nil;
    return sgmlTagValueForAttributeAtIndex(self, attributeIndex);
}

- (BOOL)attributePresent:(NSString *)attributeName;
{
    unsigned int attributeIndex;

    attributeIndex = [nonretainedTagType indexOfAttribute:attributeName];
    return sgmlTagAttributePresentAtIndex(self, attributeIndex);
}

//

- (NSString *)valueForAttributeAtIndex:(unsigned int)index;
{
    return sgmlTagValueForAttributeAtIndex(self, index);
}

- (BOOL)attributePresentAtIndex:(unsigned int)index;
{
    return sgmlTagAttributePresentAtIndex(self, index);
}

// OWSGMLToken protocol

- (NSString *)htmlString;
{
    NSMutableString *htmlString;
    NSArray *attributeNames;
    unsigned int attributeIndex, attributeCount;

    htmlString = [NSMutableString stringWithCapacity:[[nonretainedTagType name] length] + 3];
    [htmlString appendString:(tokenType == OWSGMLTokenTypeStartTag) ? @"<" : @"</"];
    [htmlString appendString:[nonretainedTagType name]];
    attributeNames = [nonretainedTagType attributeNames];
    attributeCount = [attributeNames count];
    for (attributeIndex = 0; attributeIndex < attributeCount; attributeIndex++) {
        NSString *attributeName, *attributeValue;

        attributeName = [attributeNames objectAtIndex:attributeIndex];
        attributeValue = attributes[attributeIndex];

        if (!attributeValue)
            continue;
        [htmlString appendFormat:@" %@", attributeName];
        if ([attributeValue isNull])
            continue;
        if ([attributeValue rangeOfCharacterFromSet:requiresQuotesCharacterSet].length) {
            [htmlString appendFormat:@"=\"%@\"", [attributeValue stringWithEntitiesQuoted]];
        } else {
            [htmlString appendFormat:@"=%@", attributeValue];
        }
    }
    [htmlString appendString:@">"];
    return htmlString;
}

- (NSString *)string;
{
    return [self htmlString];
}

- (OWSGMLTokenType)tokenType;
{
    return tokenType;
}

// Debugging

- (NSString *)shortDescription;
{
    return [self htmlString];
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;
    NSString *typeString;

    debugDictionary = [super debugDictionary];
    switch (tokenType) {
        case OWSGMLTokenTypeStartTag:
            typeString = @"StartTag";
            break;
        case OWSGMLTokenTypeEndTag:
            typeString = @"EndTag";
            break;
        default:
            typeString = nil;
            break;
    }
    if (typeString)
	[debugDictionary setObject:typeString forKey:@"_type"];
    if (nonretainedTagType)
        [debugDictionary setObject:nonretainedTagType forKey:@"nonretainedTagType"];
    [debugDictionary setObject:[self attributes] forKey:@"attributes"];
    return debugDictionary;
}

@end
