// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLTagType.h,v 1.8 2000/01/19 23:36:17 kc Exp $

#import <OmniFoundation/OFTrieBucket.h>

@class NSArray, NSMutableArray;
@class OFTrie;
@class OWSGMLTag;

@interface OWSGMLTagType : OFTrieBucket
{
@public
    NSString *name;
    unsigned int dtdIndex;
    OWSGMLTagType *masterAttributesTagType;
    NSMutableArray *attributeNames;
    OFTrie *attributeTrie;
    BOOL contentIsNotValidSGML;

    OWSGMLTag *attributelessStartTag;
    OWSGMLTag *attributelessEndTag;
    /* TODO: attributelessEmptyTag for XML ? */
}

- initWithName:(NSString *)aName dtdIndex:(unsigned int)anIndex;

- (NSString *)name;
- (unsigned int)dtdIndex;
- (OWSGMLTagType *)masterAttributesTagType;
- (NSArray *)attributeNames;
- (OFTrie *)attributeTrie;
- (BOOL)contentIsNotValidSGML;

- (void)shareAttributesWithTagType:(OWSGMLTagType *)aTagType;
- (unsigned int)addAttributeNamed:(NSString *)attributeName;
- (unsigned int)indexOfAttribute:(NSString *)attributeName;
- (BOOL)hasAttributeNamed:(NSString *)attributeName;

- (void)setContentIsNotValidSGML:(BOOL)newValue;

- (OWSGMLTag *)attributelessStartTag;
- (OWSGMLTag *)attributelessEndTag;

@end

static inline unsigned int tagTypeDtdIndex(OWSGMLTagType *tagType)
{
    return tagType->dtdIndex;
}
