// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWCSSSelector.h"

#import "OWSGMLTag.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSSelector.m,v 1.11 2000/12/21 23:01:05 corwin Exp $")

@implementation OWCSSSelector

-init;
{
    if (! [super init])
        return nil;    
    tagName = @"";
    className = @"";
    IDName = @"";
    pseudoClassName = @"";
    score = 0;
    return self;
}

- (void) dealloc;
{
    [tagName release];
    [className release];
    [IDName release];
    [pseudoClassName release];
    [super dealloc];
}

-(void)setTagName:(NSString *)newName;
{
    [tagName release];
    tagName = [newName copy];
}

-(void)setClassName:(NSString *)newName;
{
    [className release];
    className = [newName copy];
}

-(void)setIDName:(NSString *)newName;
{
    [IDName release];
    IDName = [newName copy];
}

-(void)setPseudoClassName:(NSString *)newName;
{
    [pseudoClassName release];
    pseudoClassName = [newName copy];
}

-(NSString *)tagName;
{
    return tagName;
}

-(NSString *)className;
{
    return className;
}

-(NSString *)IDName;
{
    return IDName;
}

-(NSString *)pseudoClassName;
{
    return pseudoClassName;
}

-(BOOL)isEqual:(OWCSSSelector *)selector;
{
    if (! [[selector tagName] isEqualToString:tagName]) {
        return NO;
    }
    if (! [[selector className] isEqualToString:className]) {
        return NO;
    }
    if (! [[selector IDName] isEqualToString:IDName]) {
        return NO;
    }
    if (! [[selector pseudoClassName] isEqualToString:pseudoClassName]) {
        return NO;
    }
    return YES;
}

-(BOOL)matchesTag:(OWSGMLTag *)tag;
{
    if (![tagName isEqualToString:@""]) {
        if (![tagName isEqualToString:[tag name]]) {
            return NO;
        }
    }
    if (![className isEqualToString:@""]) {
        if (![className isEqualToString:[tag valueForAttribute:@"class"]]) {
            return NO;
        }
    }
    if (![IDName isEqualToString:@""]) {
        if (![IDName isEqualToString:[tag valueForAttribute:@"id"]]) {
            return NO;
        }
    }
    // We only support pseudo-classes on anchor tags, so if this selector has a pseudo-class and it's
    // not an anchor tag, we die. If we do have a pseudo-class AND it is an anchor, then the only way
    // we are in here is if it's one of the pseudoclasses we support.
    if (![pseudoClassName isEqualToString:@""]) {
        if (![[tag name] isEqualToString:@"a"])
            return NO;
    }
    return YES;
}

// From http://www.w3.org/TR/REC-CSS1#cascading-order - not quite correct, but close.
-(unsigned int)score;
{
    if (score == 0) {
        if ([tagName length])
            score += 1;
        if ([className length])
            score += 10;
        if ([pseudoClassName length])
            score += 10;
        if ([IDName length])
            score += 100;
    }
    
    return score;
}

#if 0
-(NSString *)description;
{
    return [NSString stringWithFormat:@"{\n\ttagName = '%@'\n\tclassName = '%@'\n\tIDName = '%@'\n}\n", tagName, className, IDName];
}
#endif

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if(tagName)
        [debugDictionary setObject:tagName forKey:@"tagName"];
    if(className)
        [debugDictionary setObject:className forKey:@"className"];
    if(IDName)
        [debugDictionary setObject:IDName forKey:@"IDName"];

    return debugDictionary;
}


@end
