// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSSelectorGroup.h,v 1.6 2000/12/21 03:32:57 corwin Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary;
@class OWCSSSelector;

@interface OWCSSSelectorGroup : OFObject
{
    NSArray *selectorList;
    NSDictionary *declarations;
    unsigned int position;
    unsigned int score;
}

- initWithSelectorList:(NSArray *)newList withDeclarations:(NSDictionary *)newDeclarations withPosition:(unsigned int)newPosition;
- (OWCSSSelector *)lastSelector;
- (NSArray *)selectorList;
- (NSDictionary *)declarations;
- (unsigned int)score;
- (unsigned int)count;
- (unsigned int)position;
- (NSComparisonResult) compare:(OWCSSSelectorGroup *)group;

@end
