// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWCSSSelectorGroup.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "OWCSSSelector.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSSelectorGroup.m,v 1.11 2000/12/21 03:32:57 corwin Exp $")

@implementation OWCSSSelectorGroup

- initWithSelectorList:(NSArray *)newList withDeclarations:(NSDictionary *)newDeclarations withPosition:(unsigned int)newPosition;
{
    if (![super init])
        return nil;
    selectorList = [newList retain];
    declarations = [newDeclarations retain];
    position = newPosition;
    score = 0;
    return self;
}

- init;
{
    OBRejectUnusedImplementation(self, _cmd);
    return nil;
}

- (void)dealloc;
{
    [selectorList release];
    [declarations release];
    [super dealloc];
}

- (OWCSSSelector *)lastSelector;
{
    return [selectorList lastObject];
}

- (NSArray *)selectorList;
{
    return selectorList;
}

- (NSDictionary *)declarations;
{
    return declarations;
}

- (unsigned int)score;
{
    if (score == 0) {
        unsigned int selectorCount = [selectorList count];
        unsigned int selectorIndex;
        for (selectorIndex = 0; selectorIndex < selectorCount; selectorIndex++) {
            OWCSSSelector *selector = [selectorList objectAtIndex:selectorIndex];
            score += [selector score];
        }
    }
    //NSLog(@"score for group: '%@' is '%d'", [selectorList description], score); 
    return score;
}

- (unsigned int)count;
{
    return [selectorList count];
}

- (unsigned int)position;
{
    return position;
}

- (NSComparisonResult) compare:(OWCSSSelectorGroup *)group;
{
    if ([group score] > [self score])
        return NSOrderedAscending;
    else if (([group score] == [self score]) && ([group position] > [self position]))
        return NSOrderedAscending;
    else
        return NSOrderedDescending;
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:selectorList forKey:@"selectorList"];
    [debugDictionary setObject:declarations forKey:@"declarations"];

    return debugDictionary;
}


@end
