// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSStyleSheet.h,v 1.13 2000/12/21 03:36:30 corwin Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSMutableArray, NSString, NSDictionary, NSMutableDictionary;
@class OWCSSSelectorGroup, OWObjectStreamCursor, OWAddress, OWSGMLProcessor;

@interface OWCSSStyleSheet : OFObject
{
    NSMutableArray *processedStyleSheets;  // for debugging, basically
    NSMutableDictionary *lastSelectorsByTag;
    NSMutableDictionary *lastSelectorsByClass;
    NSMutableDictionary *lastSelectorsByID;
    NSMutableDictionary *lastSelectorsByPseudoclass;
    OWAddress *baseAddress;
    OWSGMLProcessor *nonretained_processor;
    unsigned int currentPosition;
}

- initWithSGMLProcessor:(OWSGMLProcessor *)proc;
- (void)processStyleSheetContent:(NSString *)styleSheet;
- (void)parseStyleSheet:(NSString *)sheet;
- (NSString *)getStyleSheetFromURLString:(NSString *)where;
- (NSArray *)parseSelectorString:(NSString *)selectors;
- (NSString *)removeComments:(NSString *)pre;
+ (NSDictionary *)parseDeclaration:(NSString *)declaration;
- (void)addSelectorGroup:(OWCSSSelectorGroup *)group;

-(BOOL)checkTagStack:(NSArray *)tagStack forSelectorGroup:(OWCSSSelectorGroup *)group;

-(NSDictionary *)findDeclarationsForTag:(NSString *)name withStack:(NSArray *)tagStack;
-(NSDictionary *)findDeclarationsForClass:(NSString *)name withStack:(NSArray *)tagStack;
-(NSDictionary *)findDeclarationsForID:(NSString *)name withStack:(NSArray *)tagStack;
-(NSDictionary *)findDeclarationsForPseudoClass:(NSString *)name withStack:(NSArray *)tagStack;

@end
