// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWDataStreamCursor.h,v 1.13 2000/10/04 20:04:51 wiml Exp $

#import <OWF/OWCursor.h>

@class NSData;
@class OWDataStream;

#import <OWF/OWStringDecoderProtocol.h>

#import <OmniFoundation/OFByte.h>
#import <OmniFoundation/OFByteOrder.h>

@interface OWDataStreamCursor : OWCursor
{
    OWDataStream *dataStream;
    OFByteOrder byteOrder;

    unsigned int dataOffset;
    OFByte partialByte;
    unsigned int bitsLeft;
}

- initForDataStream:(OWDataStream *)aStream;
- (OWDataStream *)dataStream;

- (void)setByteOrder:(OFByteOrder)newByteOrder;

- (void)skipBytes:(unsigned int)byteCount;

- (unsigned int)currentOffset;
- (BOOL)isAtEOF;

- (void)readBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (void)peekBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;

- (void)bufferBytes:(unsigned int)count;
    // Ensures that 'count' bytes are buffered.

- (unsigned int)readMaximumBytes:(unsigned int)maximum intoBuffer:(void *)buffer;
    // Reads up to 'maximum' bytes into 'buffer', returns the number of bytes actually read.
- (unsigned int)peekMaximumBytes:(unsigned int)maximum intoBuffer:(void *)buffer;
    // Peeks up to 'maximum' bytes into 'buffer', returns the number of bytes actually read.
- (NSData *)readData;
    // Reads the buffered bytes.
- (NSData *)peekData;
    // Peeks at the buffered bytes.
    
- (unsigned int)readUnderlyingBuffer:(void **)returnedBufferPtr;    

- (NSData *)readAllData;
    // Reads all remaining data. If the stream is already at EOF, this will return nil (instead of an empty NSData as you might expect).

- (NSData *)readBytes:(unsigned int)byteCount;
- (NSData *)peekBytes:(unsigned int)byteCount;

- (OFByte)readByte;
- (OFByte)peekByte;
- (int)readInt;
- (int)peekInt;
- (short)readShort;
- (short)peekShort;
- (long)readLong;
- (long)peekLong;
- (long long)readLongLong;
- (long long)peekLongLong;
- (float)readFloat;
- (float)peekFloat;
- (double)readDouble;
- (double)peekDouble;

- (unsigned int)readBits:(unsigned int)number;
- (int)readSignedBits:(unsigned int)number;
- (void)skipToNextFullByte;

- (unsigned)scanUpToByte:(OFByte)byteMatch; // Positions the offset _before_ the byte.

@end

#import <OWF/FrameworkDefines.h>

OWF_EXTERN NSException *OWDataStreamCursor_UnderflowException;
// OWF_EXTERN NSException *OWDataStreamCursor_EndOfDataException; // apparently unused --wim
