// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/OWSimpleTarget.h,v 1.1 2000/10/30 23:00:15 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSConditionLock;
@class OWContentInfo, OWContentType;

#import <OmniFoundation/OFWeakRetainProtocol.h>
#import <OWF/OWContentProtocol.h>
#import <OWF/OWTargetProtocol.h>

@interface OWSimpleTarget : OFObject <OWTarget, OFWeakRetain>
{
    OWContentInfo *parentContentInfo;
    OWContentType *targetContentType;
    NSConditionLock *resultLock;
    id <OWContent> resultingContent;
    BOOL acceptsAlternateContent;
}

- initWithParentContentInfo:(OWContentInfo *)contentInfo targetContentType:(OWContentType *)contentType;

- (void)setAcceptsAlternateContent:(BOOL)shouldAcceptAlternateContent;
- (id <OWContent>)resultingContent;

@end
