// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentType.h,v 1.13 2000/10/16 10:24:28 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentTypeLink;
@class NSArray, NSMutableArray, NSMutableSet, NSSet, NSString;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface OWContentType : OFObject
{
    NSString *contentTypeString;
    unsigned int hash;
    NSMutableSet *links;
    NSMutableSet *reverseLinks;
    NSArray *extensions;
    unsigned long hfsType, hfsCreator;
    NSTimeInterval expirationTimeInterval;

    NSString *imageName;
    NSString *readableString;
    
    BOOL isEncoding;     // Is it actually a Content-Encoding?
    BOOL isPublic;       // Is it visible to the outside world?
    BOOL isInteresting;  // Should we mention it in HTTP Accept: ?
}

+ (OWContentType *)contentTypeForString:(NSString *)aString;
+ (OWContentType *)wildcardContentType;
+ (NSArray *)contentEncodings;
+ (NSArray *)contentTypes;
+ (void)setDefaultExpirationTimeInterval:(NSTimeInterval)newTimeInterval;
+ (void)updateExpirationTimeIntervalsFromDefaults;

+ (OWContentTypeLink *)linkForTargetContentType:(OWContentType *)targetContentType fromContentType:(OWContentType *)sourceContentType orContentTypes:(NSSet *)sourceTypes;

+ (OWContentType *)contentTypeForExtension:(NSString *)extension;
+ (OWContentType *)contentTypeForFilename:(NSString *)filename isLocalFile:(BOOL)isLocalFile;
- (void)setExtensions:(NSArray *)someExtensions;
- (NSArray *)extensions;
- (NSString *)primaryExtension;

- (void)setHFSType:(unsigned long)newHFSType;
- (unsigned long)hfsType;
- (void)setHFSCreator:(unsigned long)newHFSCreator;
- (unsigned long)hfsCreator;

- (void)setImageName:(NSString *)newImageName;
- (NSString *)imageName;

- (NSString *)contentTypeString;
- (NSString *)readableString;
- (BOOL)isEncoding;
- (BOOL)isPublic;
- (BOOL)isInteresting;

- (void)linkToContentType:(OWContentType *)targetContentType usingProcessorClassName:(NSString *)aProcessorClassName cost:(float)aCost;

- (NSTimeInterval)expirationTimeInterval;
- (void)setExpirationTimeInterval:(NSTimeInterval)newTimeInterval;

- (NSSet *)directSourceContentTypes;
- (NSSet *)indirectSourceContentTypes;

- (NSString *)pathForEncoding:(OWContentType *)contentEncoding givenOriginalPath:(NSString *)aPath;

@end

#import <OWF/FrameworkDefines.h>

OWF_EXTERN NSTimeInterval OWContentTypeNeverExpireTimeInterval;
OWF_EXTERN NSTimeInterval OWContentTypeExpireWhenFlushedTimeInterval;
OWF_EXTERN NSString *OWContentTypeNeverExpireString;
OWF_EXTERN NSString *OWContentTypeExpireWhenFlushedString;
OWF_EXTERN NSString *OWContentTypeReloadExpirationTimeIntervalsNotificationName;
