// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWParameterizedContentType.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>
#import <OWF/OWHeaderDictionary.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWParameterizedContentType.m,v 1.4 2000/10/24 14:47:45 kc Exp $")

@implementation OWParameterizedContentType

+ (OWParameterizedContentType *)contentTypeForString:(NSString *)aString
{
    NSString *bareType;
    OFMultiValueDictionary *contentParameters;
    OWParameterizedContentType *returnValue;
    
    if (aString == nil)
        return nil;

    if ([aString containsString:@";"]) {
        contentParameters = [[OFMultiValueDictionary alloc] init];
        bareType = [OWHeaderDictionary parseParameterizedHeader:aString intoDictionary:contentParameters valueChars:nil];
    } else {
        contentParameters = nil;
        bareType = aString;
    }
    
    returnValue = [[OWParameterizedContentType alloc] initWithContentType:[OWContentType contentTypeForString:bareType] parameters:contentParameters];
    
    [contentParameters release];
    
    return [returnValue autorelease];
}

- initWithContentType:(OWContentType *)aType;
{
    return [self initWithContentType:aType parameters:nil];
}

- initWithContentType:(OWContentType *)aType parameters:(OFMultiValueDictionary *)someParameters;
{
    if (!(self = [super init]))
        return nil;
    
    contentType = [aType retain];
        
    if (someParameters != nil)
        parameters = [someParameters retain];
    else
        parameters = nil;
    
    return self;
}

- (void)dealloc
{
    [contentType release];
    [parameters release];
    [super dealloc];
}

- (OWContentType *)contentType;
{
    return contentType;
}

- (OWContentType *)type;
    // DEPRECATED: Use -contentType instead
{
    return contentType;
}

- (OFMultiValueDictionary *)parameters;
{
    return parameters;
}

- (NSString *)objectForKey:(NSString *)aName;
{
    return [parameters lastObjectForKey:aName];
}

- (void)setObject:(NSString *)newValue forKey:(NSString *)aName;
{
    if (!parameters)
        parameters = [[OFMultiValueDictionary alloc] init];

    [parameters addObject:newValue forKey:aName];
}

- (NSString *)contentTypeString;
{
    if (parameters != nil) {
        NSString *parameterString = [OWHeaderDictionary formatHeaderParameters:parameters onlyLastValue:YES];
    
        if ([parameterString length] > 0)
            return [NSString stringWithStrings:[contentType contentTypeString], @"; ", parameterString, nil];
    }
    
    return [contentType contentTypeString];
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:contentType forKey:@"contentType"];
    if (parameters != nil)
        [debugDictionary setObject:parameters forKey:@"parameters"];

    return debugDictionary;
}


@end
