// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWProcessorDescription.h,v 1.1 2000/11/27 23:57:10 bungi Exp $


#import <OmniFoundation/OFObject.h>

@class NSArray, NSMutableArray, NSString;
@class OWContentType;

@interface OWProcessorDescription : OFObject
{
    NSString *processorClassName;
    NSString *bundlePath;
    NSMutableArray *sourceContentTypes;
    NSString *description;
    
    Class processorClass;
}

+ (OWProcessorDescription *) processorDescriptionForProcessorClassName: (NSString *) className;
+ (NSArray *) processorDescriptions;

- (NSString *) processorClassName;
- (NSArray *) sourceContentTypes;

- (Class) processorClass;

- (NSString *) bundlePath;
- (void) setBundlePath: (NSString *) aPath;

- (NSString *) description;
- (void) setDescription: (NSString *) aDescription;

- (void) registerProcessesContentType: (OWContentType *) sourceContentType toContentType:(OWContentType *)resultContentType cost:(float)cost;

@end



