// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWProcessorDescription.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWProcessorDescription.m,v 1.1 2000/11/27 23:57:10 bungi Exp $")


static NSLock *registrationLock = nil;
static NSMutableDictionary *descriptionByName = nil;

@interface OWProcessorDescription (PrivateAPI)
- (id) _initWithProcessorClassName: (NSString *) name;
@end

@implementation OWProcessorDescription

+ (void) initialize;
{
    OBINITIALIZE;
    
    registrationLock = [[NSLock alloc] init];
    descriptionByName = [[NSMutableDictionary alloc] init];
}

+ (OWProcessorDescription *) processorDescriptionForProcessorClassName: (NSString *) className;
{
    OWProcessorDescription *aDescription;
    
    [registrationLock lock];
    aDescription = [descriptionByName objectForKey: className];
    if (!aDescription) {
        aDescription = [[self alloc] _initWithProcessorClassName: className];
        [descriptionByName setObject: aDescription forKey: className];
        [aDescription release];
    }
    [registrationLock unlock];

    return aDescription;
}

+ (NSArray *) processorDescriptions;
{
    NSArray *processorDescriptions;
    
    [registrationLock lock];
    processorDescriptions = [descriptionByName allValues];
    [registrationLock unlock];
    
    return processorDescriptions;
}

- init;
{
    [self doesNotRecognizeSelector:_cmd];
    return nil;
}

- (void) dealloc;
{
    [processorClassName release];
    [bundlePath release];
    [sourceContentTypes release];
    [super dealloc];
}

- (NSString *) processorClassName;
{
    return processorClassName;
}

- (NSArray *) sourceContentTypes;
{
    return sourceContentTypes;
}

- (Class) processorClass;
{
    if (!processorClass)
        processorClass = [OFBundledClass classNamed: processorClassName];
    return processorClass;
}

- (NSString *) bundlePath;
{
    return bundlePath;
}

- (void) setBundlePath: (NSString *) aPath;
{
    [bundlePath autorelease];
    bundlePath = [aPath copy];
}

- (NSString *) description;
{
    return description;
}

- (void) setDescription: (NSString *) aDescription;
{
    [description autorelease];
    description = [aDescription copy];
}


- (void) registerProcessesContentType: (OWContentType *) sourceContentType toContentType:(OWContentType *)resultContentType cost:(float)cost;
{
    [sourceContentTypes addObject: sourceContentType];
    [sourceContentType linkToContentType:resultContentType usingProcessorClassName:processorClassName cost:cost];
}

// OFBundleRegistryTarget informal protocol

+ (void)registerItemName:(NSString *)itemName bundle:(NSBundle *)bundle description:(NSDictionary *)descriptionDict;
{
    NSEnumerator *conversionEnumerator;
    NSDictionary *conversionDictionary;
    OWProcessorDescription *processorDescription;
    NSString *descriptionString;
    
    [OFBundledClass createBundledClassWithName:itemName bundle:bundle description:descriptionDict];

    processorDescription = [self processorDescriptionForProcessorClassName: itemName];
    [processorDescription setBundlePath: [bundle bundlePath]];

    descriptionString = [descriptionDict objectForKey: @"description"];
    if (descriptionString)
        [processorDescription setDescription: descriptionString];
    
    conversionEnumerator = [[descriptionDict objectForKey:@"converts"] objectEnumerator];
    while ((conversionDictionary = [conversionEnumerator nextObject])) {
	OWContentType *inputType, *outputType;
	NSString *aCostObject;
	float aCost;

	inputType = [OWContentType contentTypeForString:[conversionDictionary objectForKey:@"input"]];
	outputType = [OWContentType contentTypeForString:[conversionDictionary objectForKey:@"output"]];
	aCostObject = [conversionDictionary objectForKey:@"cost"];
	aCost = aCostObject ? [aCostObject floatValue] : 1.0;
        
        [processorDescription registerProcessesContentType: inputType toContentType: outputType cost: aCost];
    }
}

// Debugging

- (NSMutableDictionary *) debugDictionary;
{
    NSMutableDictionary *dict;
    
    dict = [super debugDictionary];
    [dict setObject: processorClassName forKey: @"processorClassName"];
    [dict setObject: sourceContentTypes forKey: @"sourceContentTypes"];
    if (bundlePath)
        [dict setObject: bundlePath forKey: @"bundlePath"];
    if (description)
        [dict setObject: description forKey: @"description"];
    
    return dict;
}


@end


@implementation OWProcessorDescription (PrivateAPI)

- (id) _initWithProcessorClassName: (NSString *) name;
{
    processorClassName = [name copy];
    description = [processorClassName retain];
    sourceContentTypes = [[NSMutableArray alloc] init];
    bundlePath = [[[NSBundle mainBundle] bundlePath] retain];
    
    return self;
}

@end


