// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWXMLURLFileProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentCache.h"
#import "OWContentType.h"
#import "OWAddress.h"
#import "OWDataStreamProcessor.h"
#import "OWDataStreamScanner.h"
#import "OWDataStreamCharacterCursor.h"
#import "OWPipeline.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWXMLURLFileProcessor.m,v 1.1 2000/10/16 10:19:20 wjs Exp $")

static OWContentType *sourceContentType;

@implementation OWXMLURLFileProcessor

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    sourceContentType = [OWContentType contentTypeForString:@"application/x-xml-url"];
}

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:sourceContentType toContentType:[OWContentType wildcardContentType] cost:1.0];
}

+ (OWContentType *)sourceContentType;
{
    return sourceContentType;
}

- (void)process;
{
    OWDataStreamScanner *dataStreamScanner;
    NSString *urlString;
    OWAddress *anAddress;

    // Sherlock writes Mac OS content type "ilht" files that look like this:
    //
    // <?xml version="1.0" encoding="UTF-8"?>
    // <!DOCTYPE plist SYSTEM "file://localhost/System/Library/DTDs/PropertyList.dtd">
    // <plist version="0.9">
    // <dict>
    // 	<key>URL</key>
    // 	<string>http://search.britannica.com/sherlock_redir.jsp?href=http%3A%2F%2Fwww.britannica.com%2Fbcom%2Feb%2Farticle%2F1%2F0%2C5716%2C42921%2B1%2B41973%2C00.html</string>
    // </dict>
    // </plist>

    dataStreamScanner = [[OWDataStreamScanner alloc] initWithCursor:characterCursor];
    
    if (![dataStreamScanner scanString:@"<?xml version" peek:YES])
        return;
        
    if (![dataStreamScanner scanUpToString:@"<string>"])
        return;
    if (![dataStreamScanner scanString:@"<string>" peek:NO])
        return;
        
    urlString = [dataStreamScanner readFullTokenWithDelimiterCharacter:'<'];
    if (urlString == nil || [urlString length] == 0)
        return;
        
    anAddress = [OWAddress addressForDirtyString:urlString];
    [pipeline addContent:anAddress];
    [pipeline cacheContent];
    [pipeline startProcessingContent];
}

@end
