// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/FTP.subproj/OWFTPSession.h,v 1.3 2000/01/19 23:36:09 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSData;
@class ONSocket, ONSocketStream;
@class OWAddress, OWPipeline, OWProcessor;

@interface OWFTPSession : OFObject
{
    NSString *sessionCacheKey;
    ONSocketStream *controlSocketStream;
    NSString *currentPath;
    NSString *currentTransferType;
    NSString *systemType;
    NSString *lastReply;
    unsigned int lastReplyIntValue;
    NSString *lastMessage;

    OWAddress *ftpAddress;
    OWPipeline *nonretainedPipeline;
    OWProcessor *nonretainedProcessor;
    BOOL abortOperation;
    ONSocket *abortSocket;
}

+ (void)readDefaults;
+ (OWFTPSession *)ftpSessionForAddress:(OWAddress *)anAddress;
+ (OWFTPSession *)ftpSessionForNetLocation:(NSString *)aNetLocation;

- initWithNetLocation:(NSString *)aNetLocation;

// Operations
- (void)fetchForProcessor:(OWProcessor *)aProcessor inPipeline:(OWPipeline *)aPipeline;
- (void)abortOperation;

@end
