// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWAuthorizationRealm.h,v 1.6 2000/01/19 23:36:13 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSConditionLock, NSMutableArray, NSMutableDictionary;
@class OWHeaderDictionary;

@interface OWAuthorizationRealm : OFObject
{
    NSString *name;
    NSString *defaultsKey;
    NSMutableDictionary *credentialsByScheme;
    NSConditionLock *credentialsLock;
    NSMutableArray *cachedCredentials;
}

+ (void)registerSelector:(SEL)aSelector forScheme:(NSString *)aScheme;
+ (OWAuthorizationRealm *)realmWithName:(NSString *)aName forHostAddress:(NSString *)hostAddress;

- (NSArray *)credentials;
- (void)generateCredentialsForScheme:(NSString *)scheme challenge:(OWHeaderDictionary *)challenge reprompt:(BOOL)shouldReprompt;
- (void)setCredentials:(NSArray *)credentials forScheme:(NSString *)scheme save:(BOOL)shouldSave;

@end
