// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/OWNNTPSession.h,v 1.10 2000/03/25 06:44:38 wjs Exp $

#import <OWF/OWAbstractContent.h>

@class NSLock;
@class ONSocketStream;
@class OWAddress, OWContentType, OWPipeline, OWProcessor;

@interface OWNNTPSession : OWAbstractContent
{
    NSLock         *serverLock;
    ONSocketStream *controlSocketStream;
    NSString       *serverName;
    
    OWPipeline     *nonretainedPipeline;
    OWProcessor    *nonretainedProcessor;
    
    NSString       *lastReply;
    unsigned int    lastReplyIntValue;
    BOOL            abortFetch;
}

+ (NSString *) defaultNNTPServerHostName;

+ (OWContentType *) newsServerType;
+ (OWContentType *)newsgroupArticleType;
+ (OWContentType *)newsgroupHeaderListType;

+ (OWNNTPSession *) nntpSessionForAddress: (OWAddress *) address;

- initWithNewsServer: (NSString *) aServerName;

- (void)fetchForProcessor:(OWProcessor *)aProcessor inPipeline:(OWPipeline *)aPipeline;
- (void)abortFetch;

@end
