// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLProcessor.h,v 1.10 2000/08/26 02:10:36 bungi Exp $

#import <OWF/OWObjectStreamProcessor.h>

#import <OWF/OWCSSStyleSheet.h>

@class NSUserDefaults;
@class OWAddress, OWSGMLAppliedMethods, OWSGMLDTD, OWSGMLMethods, OWSGMLTag, OWSGMLTagType;

@interface OWSGMLProcessor : OWObjectStreamProcessor
{
    OWSGMLAppliedMethods *appliedMethods;
    OWAddress *baseAddress;
    unsigned int *openTags;
    NSMutableArray *tagStack;
    NSMutableArray *undoers;
    OWCSSStyleSheet *styleSheet;
}

+ (OWSGMLMethods *)sgmlMethods;
+ (OWSGMLDTD *)dtd;

+ (void)setDebug:(BOOL)newDebugSetting;

- (void)setBaseAddress:(OWAddress *)anAddress;

- (BOOL)hasOpenTagOfType:(OWSGMLTagType *)tagType;
- (void)openTagOfType:(OWSGMLTagType *)tagType;
- (void)closeTagOfType:(OWSGMLTagType *)tagType;

- (void)processContentForTag:(OWSGMLTag *)tag;
- (void)processUnknownTag:(OWSGMLTag *)tag;
- (void)processIgnoredContentsTag:(OWSGMLTag *)tag;
- (void)processTag:(OWSGMLTag *)tag;
- (BOOL)processEndTag:(OWSGMLTag *)tag;
- (void)processCData:(NSString *)cData;

-(void)applyCSSStylesForTag:(OWSGMLTag *)tag;
-(void)reverseCSSStylesForTag:(OWSGMLTag *)tag;
-(NSDictionary *)executeDeclarations:(NSDictionary *)declarations;

- (OWAddress *)baseAddress;

@end

@interface OWSGMLProcessor (Tags)
- (OWAddress *)addressForAnchorTag:(OWSGMLTag *)tag;
- (void)processMeaninglessTag:(OWSGMLTag *)tag;
- (void)processBaseTag:(OWSGMLTag *)tag;
- (void)processMetaTag:(OWSGMLTag *)tag;
- (void)processTitleTag:(OWSGMLTag *)tag;
@end
