// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWCSSDeclarations.h"

#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>

#import "OWCSSIdentifier.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSDeclarations.m,v 1.10 2001/03/17 03:17:54 wjs Exp $");

@interface OWCSSDeclarations (Private)
@end

@implementation OWCSSDeclarations

+ (OWCSSDeclarations *)declarations;
{
    return [[[self alloc] init] autorelease];
}


// Init and dealloc

- init;
{
    if (![super init])
        return self;

    bzero(declarations, sizeof(declarations));

    return self;
}

- (void)dealloc;
{
    [self releaseAndClearDeclarations];
    [super dealloc];
}


// API

- (BOOL)isEmpty;
{
    unsigned int declarationIndex;
    
    declarationIndex = CSSDeclarationsCount;
    while (declarationIndex--)
        if (declarations[declarationIndex] != nil)
            return NO;
    return YES;
}

- (BOOL)isBlock;
{
    return declarations[CSSDisplayDeclarationIndex] == OWCSSBlockIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSListItemIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSCompactIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSRunInIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableRowGroupIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableHeaderGroupIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableFooterGroupIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableRowIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableColumnGroupIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableColumnIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableCellIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSTableCaptionIdentifier
        || declarations[CSSDisplayDeclarationIndex] == OWCSSNoneIdentifier;
}

- (BOOL)startsNewBuilder;
{
    return declarations[CSSDisplayDeclarationIndex] == OWCSSTableIdentifier; // Add layers, any other embedded HTML things
}

- (BOOL)hasFontDeclarations;
{
    unsigned int declarationIndex;
    
    for (declarationIndex = CSSFontDeclarationIndex; declarationIndex <= CSSFontWeightDeclarationIndex; declarationIndex++)
        if (declarations[declarationIndex] != nil)
            return YES;
    return NO;
}

- (void)setObject:(id)object atIndex:(unsigned int)index;
{
    if (declarations[index] == object)
        return;

    [declarations[index] release];
    declarations[index] = [object retain];
}

- (void)addEntriesFromDeclarations:(OWCSSDeclarations *)otherDeclarations;
{
    unsigned int declarationIndex;
    
    if (otherDeclarations == nil)
        return;
    
    declarationIndex = CSSDeclarationsCount;
    while (declarationIndex--) {
        id object;
        
        object = otherDeclarations->declarations[declarationIndex];
        if (object != nil) {
            [declarations[declarationIndex] release];
            declarations[declarationIndex] = [object retain];
        }
    }
}

- (void)releaseAndClearDeclarations;
{
    unsigned int declarationIndex;
    
    declarationIndex = CSSDeclarationsCount;
    while (declarationIndex--) {
        [declarations[declarationIndex] release];
        declarations[declarationIndex] = nil;
    }
}

@end

@implementation OWCSSDeclarations (Private)

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;
    unsigned int propertyIndex;

    debugDictionary = [NSMutableDictionary dictionary];

    for (propertyIndex = 0; propertyIndex < CSSDeclarationsCount; propertyIndex++)
            if (declarations[propertyIndex] != nil)
                [debugDictionary setObject:declarations[propertyIndex] forKey:[OWCSSPropertyNameIdentifiers[propertyIndex] string]];

    return debugDictionary;
}


@end
