// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWCSSIdentifier.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSIdentifier.m,v 1.13 2001/03/17 06:45:27 wjs Exp $");

@interface OWCSSIdentifier (Private)
+ (OWCSSIdentifier *)_registerIdentifierForString:(NSString *)aString;
- _initWithString:(NSString *)aString;
@end

@implementation OWCSSIdentifier

static OFTrie *identifierTrie;

OWCSSIdentifier *OWCSSPropertyNameIdentifiers[CSSDeclarationsCount];

// functions
OWCSSIdentifier *OWCSSURLIdentifier;

// units
OWCSSIdentifier *OWCSSEMIdentifier, *OWCSSEXIdentifier, *OWCSSPXIdentifier, *OWCSSINIdentifier, *OWCSSCMIdentifier, *OWCSSMMIdentifier, *OWCSSPTIdentifier, *OWCSSPCIdentifier, *OWCSSPercentIdentifier;

// shared
OWCSSIdentifier *OWCSSNoneIdentifier, *OWCSSNormalIdentifier, *OWCSSInheritIdentifier;

// background: [<'background-color'> || <'background-image'> || <'background-repeat'> || <'background-attachment'> || <'background-position'>] | inherit
OWCSSIdentifier *OWCSSBackgroundIdentifier;
// background-image: <uri> | none | inherit
OWCSSIdentifier *OWCSSBackgroundImageIdentifier;
// background-color: <color> | transparent | inherit
OWCSSIdentifier *OWCSSBackgroundColorIdentifier;
OWCSSIdentifier *OWCSSTransparentIdentifier;

// bottom: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSBottomIdentifier;

// clear: none | left | right | both | inherit
OWCSSIdentifier *OWCSSClearIdentifier;

// color: <color> | inherit 
OWCSSIdentifier *OWCSSColorIdentifier;

// display: inline | block | list-item | run-in | compact | marker | table | inline-table | table-row-group | table-header-group | table-footer-group | table-row | table-column-group | table-column | table-cell | table-caption | none | inherit 
OWCSSIdentifier *OWCSSDisplayIdentifier;
OWCSSIdentifier *OWCSSInlineIdentifier, *OWCSSBlockIdentifier, *OWCSSListItemIdentifier, *OWCSSRunInIdentifier, *OWCSSCompactIdentifier, *OWCSSMarkerIdentifier, *OWCSSTableIdentifier, *OWCSSInlineTableIdentifier, *OWCSSTableRowGroupIdentifier, *OWCSSTableHeaderGroupIdentifier, *OWCSSTableFooterGroupIdentifier, *OWCSSTableRowIdentifier, *OWCSSTableColumnGroupIdentifier, *OWCSSTableColumnIdentifier, *OWCSSTableCellIdentifier, *OWCSSTableCaptionIdentifier;

// float: left | right | none | inherit 
OWCSSIdentifier *OWCSSFloatIdentifier;

// font: [ [ <font-style> || <font-variant> || <font-weight> ]? <font-size> [ / <line-height> ]? <font-family> ] | caption | icon | menu | message-box | small-caption | status-bar | inherit
OWCSSIdentifier *OWCSSFontIdentifier;
OWCSSIdentifier *OWCSSCaptionIdentifier, *OWCSSIconIdentifier, *OWCSSMenuIdentifier, *OWCSSMessageBoxIdentifier, *OWCSSSmallCaptionIdentifier, *OWCSSStatusBarIdentifier;
// font-family: [[ <family-name> | serif | sans-serif | cursive | fantasy | monospace ],]* [<family-name> | <generic-family>] | inherit 
OWCSSIdentifier *OWCSSFontFamilyIdentifier;
OWCSSIdentifier *OWCSSSerifIdentifier, *OWCSSSansSerifIdentifier, *OWCSSCursiveIdentifier, *OWCSSFantasyIdentifier, *OWCSSMonospaceIdentifier;
// font-size: [xx-small | x-small | small | medium | large | x-large | xx-large ] | [ larger | smaller ] | <length> | <percentage> | inherit 
OWCSSIdentifier *OWCSSFontSizeIdentifier;
OWCSSIdentifier *OWCSSXXSmallIdentifier, *OWCSSXSmallIdentifier, *OWCSSSmallIdentifier, *OWCSSMediumIdentifier, *OWCSSLargeIdentifier, *OWCSSXLargeIdentifier, *OWCSSXXLargeIdentifier, *OWCSSLargerIdentifier, *OWCSSSmallerIdentifier;
// font-size-adjust: <number> | none | inherit
OWCSSIdentifier *OWCSSFontSizeAdjustIdentifier;
// font-stretch: normal | wider | narrower | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded | inherit
OWCSSIdentifier *OWCSSFontStretchIdentifier;
OWCSSIdentifier *OWCSSWiderIdentifier, *OWCSSNarrowerIdentifier, *OWCSSUltraCondensedIdentifier, *OWCSSExtraCondensedIdentifier, *OWCSSCondensedIdentifier, *OWCSSSemiCondensedIdentifier, *OWCSSSemiExpandedIdentifier, *OWCSSExpandedIdentifier, *OWCSSExtraExpandedIdentifier, *OWCSSUltraExpandedIdentifier;
// font-style: normal | italic | oblique | inherit
OWCSSIdentifier *OWCSSFontStyleIdentifier;
OWCSSIdentifier *OWCSSItalicIdentifier, *OWCSSObliqueIdentifier;
// font-variant: normal | small-caps | inherit
OWCSSIdentifier *OWCSSFontVariantIdentifier;
OWCSSIdentifier *OWCSSSmallCapsIdentifier;
// font-weight: normal | bold | bolder | lighter | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | inherit 
OWCSSIdentifier *OWCSSFontWeightIdentifier;
OWCSSIdentifier *OWCSSBoldIdentifier, *OWCSSBolderIdentifier, *OWCSSLighterIdentifier;

// height: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSHeightIdentifier;

// left: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSLeftIdentifier;

// line-height: normal | <number> | <length> | <percentage> | inherit 
OWCSSIdentifier *OWCSSLineHeightIdentifier;

// margin: [ <length> | <percentage> | auto | inherit ] {1,4} | inherit
OWCSSIdentifier *OWCSSMarginIdentifier;
OWCSSIdentifier *OWCSSAutoIdentifier;
// margin-left, margin-right, margin-top, margin-bottom: : <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSMarginLeftIdentifier, *OWCSSMarginRightIdentifier, *OWCSSMarginTopIdentifier, *OWCSSMarginBottomIdentifier;

// position: static | relative | absolute | fixed | inherit
OWCSSIdentifier *OWCSSPositionIdentifier;
OWCSSIdentifier *OWCSSStaticIdentifier, *OWCSSRelativeIdentifier, *OWCSSAbsoluteIdentifier, *OWCSSFixedIdentifier;

// right: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSRightIdentifier;

// text
// text-align: left | right | center | justify | <string> | inherit 
OWCSSIdentifier *OWCSSTextAlignIdentifier;
OWCSSIdentifier *OWCSSCenterIdentifier, *OWCSSJustifyIdentifier;

// text-decoration: none | [ underline || overline || line-through || blink ] | inherit
OWCSSIdentifier *OWCSSTextDecorationIdentifier;
OWCSSIdentifier *OWCSSUnderlineIdentifier, *OWCSSOverlineIdentifier, *OWCSSLineThroughIdentifier, *OWCSSBlinkIdentifier;

// top: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSTopIdentifier;

// visibility: inherit | visible | hidden
OWCSSIdentifier *OWCSSVisibilityIdentifier;
OWCSSIdentifier *OWCSSVisibleIdentifier, *OWCSSHiddenIdentifier;

// white-space: normal | pre | nowrap | inherit
OWCSSIdentifier *OWCSSWhiteSpaceIdentifier;
OWCSSIdentifier *OWCSSPreIdentifier, *OWCSSNoWrapIdentifier;

// width: <length> | <percentage> | auto | inherit
OWCSSIdentifier *OWCSSWidthIdentifier;

// z-index: auto | <integer>
OWCSSIdentifier *OWCSSZIndexIdentifier;


+ (void)initialize;
{
    unsigned int propertyIndex;

    OBINITIALIZE;

    identifierTrie = [[OFTrie alloc] initCaseSensitive:NO];
    
    // functions
    OWCSSURLIdentifier = [self _registerIdentifierForString:@"url"];
    
    // units
    OWCSSEMIdentifier = [self _registerIdentifierForString:@"em"];
    OWCSSEXIdentifier = [self _registerIdentifierForString:@"ex"];
    OWCSSPXIdentifier = [self _registerIdentifierForString:@"px"];
    OWCSSINIdentifier = [self _registerIdentifierForString:@"in"];
    OWCSSCMIdentifier = [self _registerIdentifierForString:@"cm"];
    OWCSSMMIdentifier = [self _registerIdentifierForString:@"mm"];
    OWCSSPTIdentifier = [self _registerIdentifierForString:@"pt"];
    OWCSSPCIdentifier = [self _registerIdentifierForString:@"pc"];
    OWCSSPercentIdentifier = [self _registerIdentifierForString:@"%"];

    // shared
    OWCSSNoneIdentifier = [self _registerIdentifierForString:@"none"];
    OWCSSNormalIdentifier = [self _registerIdentifierForString:@"normal"];
    OWCSSInheritIdentifier = [self _registerIdentifierForString:@"inherit"];
    
    // background: [<'background-color'> || <'background-image'> || <'background-repeat'> || <'background-attachment'> || <'background-position'>] | inherit
    OWCSSPropertyNameIdentifiers[CSSBackgroundDeclarationIndex] = OWCSSBackgroundIdentifier = [self _registerIdentifierForString:@"background"];
    // background-color: <color> | transparent | inherit
    OWCSSPropertyNameIdentifiers[CSSBackgroundColorDeclarationIndex] = OWCSSBackgroundColorIdentifier = [self _registerIdentifierForString:@"background-color"];
    OWCSSTransparentIdentifier = [self _registerIdentifierForString:@"transparent"];
    // background-image: <uri> | none | inherit
    OWCSSPropertyNameIdentifiers[CSSBackgroundImageDeclarationIndex] = OWCSSBackgroundImageIdentifier = [self _registerIdentifierForString:@"background-image"];
    
    // bottom: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSBottomDeclarationIndex] = OWCSSBottomIdentifier = [self _registerIdentifierForString:@"bottom"];

    // clear: none | left | right | both | inherit
    OWCSSPropertyNameIdentifiers[CSSClearDeclarationIndex] = OWCSSClearIdentifier = [self _registerIdentifierForString:@"clear"];

    // color: <color> | inherit 
    OWCSSPropertyNameIdentifiers[CSSColorDeclarationIndex] = OWCSSColorIdentifier = [self _registerIdentifierForString:@"color"];

    // display: inline | block | list-item | run-in | compact | marker | table | inline-table | table-row-group | table-header-group | table-footer-group | table-row | table-column-group | table-column | table-cell | table-caption | none | inherit 
    OWCSSPropertyNameIdentifiers[CSSDisplayDeclarationIndex] = OWCSSDisplayIdentifier = [self _registerIdentifierForString:@"display"];
    OWCSSInlineIdentifier = [self _registerIdentifierForString:@"inline"];
    OWCSSBlockIdentifier = [self _registerIdentifierForString:@"block"];
    OWCSSListItemIdentifier = [self _registerIdentifierForString:@"list-tiem"];
    OWCSSRunInIdentifier = [self _registerIdentifierForString:@"run-in"];
    OWCSSCompactIdentifier = [self _registerIdentifierForString:@"compact"];
    OWCSSMarkerIdentifier = [self _registerIdentifierForString:@"marker"];
    OWCSSTableIdentifier = [self _registerIdentifierForString:@"table"];
    OWCSSInlineTableIdentifier = [self _registerIdentifierForString:@"inline-table"];
    OWCSSTableRowGroupIdentifier = [self _registerIdentifierForString:@"table-row-group"];
    OWCSSTableHeaderGroupIdentifier = [self _registerIdentifierForString:@"table-header-group"];
    OWCSSTableFooterGroupIdentifier = [self _registerIdentifierForString:@"table-footer-group"];
    OWCSSTableRowIdentifier = [self _registerIdentifierForString:@"table-row"];
    OWCSSTableColumnGroupIdentifier = [self _registerIdentifierForString:@"table-column-group"];
    OWCSSTableColumnIdentifier = [self _registerIdentifierForString:@"table-column"];
    OWCSSTableCellIdentifier = [self _registerIdentifierForString:@"table-cell"];
    OWCSSTableCaptionIdentifier = [self _registerIdentifierForString:@"table-caption"];

    // float: left | right | none | inherit 
    OWCSSPropertyNameIdentifiers[CSSFloatDeclarationIndex] = OWCSSFloatIdentifier = [self _registerIdentifierForString:@"float"];

    // font: [ [ <font-style> || <font-variant> || <font-weight> ]? <font-size> [ / <line-height> ]? <font-family> ] | caption | icon | menu | message-box | small-caption | status-bar | inherit
    OWCSSPropertyNameIdentifiers[CSSFontDeclarationIndex] = OWCSSFontIdentifier = [self _registerIdentifierForString:@"font"];
    OWCSSCaptionIdentifier = [self _registerIdentifierForString:@"caption"];
    OWCSSIconIdentifier = [self _registerIdentifierForString:@"icon"];
    OWCSSMenuIdentifier = [self _registerIdentifierForString:@"menu"];
    OWCSSMessageBoxIdentifier = [self _registerIdentifierForString:@"message-box"];
    OWCSSSmallCaptionIdentifier = [self _registerIdentifierForString:@"small-caption"];
    OWCSSStatusBarIdentifier = [self _registerIdentifierForString:@"status-bar"];
    // font-family: [[ <family-name> | serif | sans-serif | cursive | fantasy | monospace ],]* [<family-name> | <generic-family>] | inherit 
    OWCSSPropertyNameIdentifiers[CSSFontFamilyDeclarationIndex] = OWCSSFontFamilyIdentifier = [self _registerIdentifierForString:@"font-family"];
    OWCSSSerifIdentifier = [self _registerIdentifierForString:@"serif"];
    OWCSSSansSerifIdentifier = [self _registerIdentifierForString:@"sans-serif"];
    OWCSSCursiveIdentifier = [self _registerIdentifierForString:@"cursive"];
    OWCSSFantasyIdentifier = [self _registerIdentifierForString:@"fantasy"];
    OWCSSMonospaceIdentifier = [self _registerIdentifierForString:@"monospace"];
    // font-size: [xx-small | x-small | small | medium | large | x-large | xx-large ] | [ larger | smaller ] | <length> | <percentage> | inherit 
    OWCSSPropertyNameIdentifiers[CSSFontSizeDeclarationIndex] = OWCSSFontSizeIdentifier = [self _registerIdentifierForString:@"font-size"];
    OWCSSXXSmallIdentifier = [self _registerIdentifierForString:@"xx-small"];
    OWCSSXSmallIdentifier = [self _registerIdentifierForString:@"x-small"];
    OWCSSSmallIdentifier = [self _registerIdentifierForString:@"small"];
    OWCSSMediumIdentifier = [self _registerIdentifierForString:@"medium"];
    OWCSSLargeIdentifier = [self _registerIdentifierForString:@"large"];
    OWCSSXLargeIdentifier = [self _registerIdentifierForString:@"x-large"];
    OWCSSXXLargeIdentifier = [self _registerIdentifierForString:@"xx-large"];
    OWCSSLargerIdentifier = [self _registerIdentifierForString:@"larger"];
    OWCSSSmallerIdentifier = [self _registerIdentifierForString:@"smaller"];
    // font-size-adjust: <number> | none | inherit
    OWCSSPropertyNameIdentifiers[CSSFontSizeAdjustDeclarationIndex] = OWCSSFontSizeAdjustIdentifier = [self _registerIdentifierForString:@"font-size-adjust"];
    // font-stretch: normal | wider | narrower | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded | inherit
    OWCSSPropertyNameIdentifiers[CSSFontStretchDeclarationIndex] = OWCSSFontStretchIdentifier = [self _registerIdentifierForString:@"font-stretch"];
    OWCSSWiderIdentifier = [self _registerIdentifierForString:@"wider"];
    OWCSSNarrowerIdentifier = [self _registerIdentifierForString:@"narrower"];
    OWCSSUltraCondensedIdentifier = [self _registerIdentifierForString:@"ultra-condensed"];
    OWCSSExtraCondensedIdentifier = [self _registerIdentifierForString:@"extra-condensed"];
    OWCSSCondensedIdentifier = [self _registerIdentifierForString:@"condensed"];
    OWCSSSemiCondensedIdentifier = [self _registerIdentifierForString:@"semi-condensed"];
    OWCSSSemiExpandedIdentifier = [self _registerIdentifierForString:@"semi-expanded"];
    OWCSSExpandedIdentifier = [self _registerIdentifierForString:@"expanded"];
    OWCSSExtraExpandedIdentifier = [self _registerIdentifierForString:@"extra-expanded"];
    OWCSSUltraExpandedIdentifier = [self _registerIdentifierForString:@"ultra-expanded"];
    // font-style: normal | italic | oblique | inherit
    OWCSSPropertyNameIdentifiers[CSSFontStyleDeclarationIndex] = OWCSSFontStyleIdentifier = [self _registerIdentifierForString:@"font-style"];
    OWCSSItalicIdentifier = [self _registerIdentifierForString:@"italic"];
    OWCSSObliqueIdentifier = [self _registerIdentifierForString:@"oblique"];
    // font-variant: normal | small-caps | inherit
    OWCSSPropertyNameIdentifiers[CSSFontVariantDeclarationIndex] = OWCSSFontVariantIdentifier = [self _registerIdentifierForString:@"font-variant"];
    OWCSSSmallCapsIdentifier = [self _registerIdentifierForString:@"small-caps"];
    // font-weight: normal | bold | bolder | lighter | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | inherit 
    OWCSSPropertyNameIdentifiers[CSSFontWeightDeclarationIndex] = OWCSSFontWeightIdentifier = [self _registerIdentifierForString:@"font-weight"];
    OWCSSBoldIdentifier = [self _registerIdentifierForString:@"bold"];
    OWCSSBolderIdentifier = [self _registerIdentifierForString:@"bolder"];
    OWCSSLighterIdentifier = [self _registerIdentifierForString:@"lighter"];

    // height: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSHeightDeclarationIndex] = OWCSSHeightIdentifier = [self _registerIdentifierForString:@"height"];

    // left: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSLeftDeclarationIndex] = OWCSSLeftIdentifier = [self _registerIdentifierForString:@"left"];

    // line-height: normal | <number> | <length> | <percentage> | inherit 
    OWCSSPropertyNameIdentifiers[CSSLineHeightDeclarationIndex] = OWCSSLineHeightIdentifier = [self _registerIdentifierForString:@"line-height"];

    // margin: [ <length> | <percentage> | auto | inherit ] {1,4} | inherit
    OWCSSPropertyNameIdentifiers[CSSMarginDeclarationIndex] = OWCSSMarginIdentifier = [self _registerIdentifierForString:@"margin"];
    OWCSSAutoIdentifier = [self _registerIdentifierForString:@"auto"];
    // margin-left, margin-right, margin-top, margin-bottom: : <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSMarginBottomDeclarationIndex] = OWCSSMarginBottomIdentifier = [self _registerIdentifierForString:@"margin-bottom"];
    OWCSSPropertyNameIdentifiers[CSSMarginLeftDeclarationIndex] = OWCSSMarginLeftIdentifier = [self _registerIdentifierForString:@"margin-left"];
    OWCSSPropertyNameIdentifiers[CSSMarginRightDeclarationIndex] = OWCSSMarginRightIdentifier = [self _registerIdentifierForString:@"margin-right"];
    OWCSSPropertyNameIdentifiers[CSSMarginTopDeclarationIndex] = OWCSSMarginTopIdentifier = [self _registerIdentifierForString:@"margin-top"];

    // position: static | relative | absolute | fixed | inherit
    OWCSSPropertyNameIdentifiers[CSSPositionDeclarationIndex] = OWCSSPositionIdentifier = [self _registerIdentifierForString:@"position"];
    OWCSSStaticIdentifier = [self _registerIdentifierForString:@"static"];
    OWCSSRelativeIdentifier = [self _registerIdentifierForString:@"relative"];
    OWCSSAbsoluteIdentifier = [self _registerIdentifierForString:@"absolute"];
    OWCSSFixedIdentifier = [self _registerIdentifierForString:@"fixed"];

    // right: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSRightDeclarationIndex] = OWCSSRightIdentifier = [self _registerIdentifierForString:@"right"];

    // text
    // text-align: left | right | center | justify | <string> | inherit 
    OWCSSPropertyNameIdentifiers[CSSTextAlignDeclarationIndex] = OWCSSTextAlignIdentifier = [self _registerIdentifierForString:@"text-align"];
    OWCSSCenterIdentifier = [self _registerIdentifierForString:@"center"];
    OWCSSJustifyIdentifier = [self _registerIdentifierForString:@"justify"];

    // text-decoration: none | [ underline || overline || line-through || blink ] | inherit
    OWCSSPropertyNameIdentifiers[CSSTextDecorationDeclarationIndex] = OWCSSTextDecorationIdentifier = [self _registerIdentifierForString:@"text-decoration"];
    OWCSSUnderlineIdentifier = [self _registerIdentifierForString:@"underline"];
    OWCSSOverlineIdentifier = [self _registerIdentifierForString:@"overline"];
    OWCSSLineThroughIdentifier = [self _registerIdentifierForString:@"line-through"];
    OWCSSBlinkIdentifier = [self _registerIdentifierForString:@"blink"];

    // top: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSTopDeclarationIndex] = OWCSSTopIdentifier = [self _registerIdentifierForString:@"top"];

    // visibility: visible | hidden | inherit
    OWCSSPropertyNameIdentifiers[CSSVisibilityDeclarationIndex] = OWCSSVisibilityIdentifier = [self _registerIdentifierForString:@"visibility"];
    OWCSSVisibleIdentifier = [self _registerIdentifierForString:@"visible"];
    OWCSSHiddenIdentifier = [self _registerIdentifierForString:@"hidden"];

    // white-space: normal | pre | nowrap | inherit
    OWCSSPropertyNameIdentifiers[CSSWhiteSpaceDeclarationIndex] = OWCSSWhiteSpaceIdentifier = [self _registerIdentifierForString:@"white-space"];
    OWCSSPreIdentifier = [self _registerIdentifierForString:@"pre"];
    OWCSSNoWrapIdentifier = [self _registerIdentifierForString:@"nowrap"];

    // width: <length> | <percentage> | auto | inherit
    OWCSSPropertyNameIdentifiers[CSSWidthDeclarationIndex] = OWCSSWidthIdentifier = [self _registerIdentifierForString:@"width"];

    // z-index: auto | <integer>
    OWCSSPropertyNameIdentifiers[CSSZIndexDeclarationIndex] = OWCSSZIndexIdentifier = [self _registerIdentifierForString:@"z-index"];

    for (propertyIndex = 0; propertyIndex < CSSDeclarationsCount; propertyIndex++)
        [OWCSSPropertyNameIdentifiers[propertyIndex] setDeclarationIndex:propertyIndex];
}

+ (OFTrie *)identifierTrie;
{
    return identifierTrie;
}

// Init and dealloc

- init;
{
    OBRejectUnusedImplementation(self, _cmd);
    return nil;
}

- (void)dealloc;
{
    [string release];
    [super dealloc];
}


// API

- (NSString *)string;
{
    return string;
}

- (void)setDeclarationIndex:(unsigned int)newIndex;
{
    declarationIndex = newIndex;
}
- (unsigned int)declarationIndex;
{
    return declarationIndex;
}

/*
- (BOOL)isZZZIdentifier;
{
    return self == OWCSS
        || self == OWCSS
        || self == OWCSS
        || self == OWCSSInheritIdentifier;
}
*/

// Font

- (BOOL)isFontFamilyIdentifier;
{
    return self == OWCSSSerifIdentifier
        || self == OWCSSSansSerifIdentifier
        || self == OWCSSCursiveIdentifier
        || self == OWCSSFantasyIdentifier
        || self == OWCSSMonospaceIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontSizeIdentifier;
{
    return self == OWCSSXXSmallIdentifier
        || self == OWCSSXSmallIdentifier
        || self == OWCSSSmallIdentifier
        || self == OWCSSMediumIdentifier
        || self == OWCSSLargeIdentifier
        || self == OWCSSXLargeIdentifier
        || self == OWCSSXXLargeIdentifier
        || self == OWCSSLargerIdentifier
        || self == OWCSSSmallerIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontSizeAdjustIdentifier;
{
    return self == OWCSSNoneIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontStretchIdentifier;
{
    return self == OWCSSNormalIdentifier
        || self == OWCSSWiderIdentifier
        || self == OWCSSNarrowerIdentifier
        || self == OWCSSUltraCondensedIdentifier
        || self == OWCSSExtraCondensedIdentifier
        || self == OWCSSCondensedIdentifier
        || self == OWCSSSemiCondensedIdentifier
        || self == OWCSSSemiExpandedIdentifier
        || self == OWCSSExpandedIdentifier
        || self == OWCSSExtraExpandedIdentifier
        || self == OWCSSUltraExpandedIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontStyleIdentifier;
{
    return self == OWCSSNormalIdentifier
        || self == OWCSSItalicIdentifier
        || self == OWCSSObliqueIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontVariantIdentifier;
{
    return self == OWCSSNormalIdentifier
        || self == OWCSSSmallCapsIdentifier
        || self == OWCSSInheritIdentifier;
}

- (BOOL)isFontWeightIdentifier;
{
    return self == OWCSSNormalIdentifier
        || self == OWCSSBoldIdentifier
        || self == OWCSSBolderIdentifier
        || self == OWCSSLighterIdentifier
        || self == OWCSSInheritIdentifier;
}

@end

@implementation OWCSSIdentifier (Private)

+ (OWCSSIdentifier *)_registerIdentifierForString:(NSString *)aString;
{
    OWCSSIdentifier *identifier;

    OBPRECONDITION([identifierTrie bucketForString:aString] == nil);
    identifier = [[self alloc] _initWithString:aString];
    [identifierTrie addBucket:identifier forString:aString];
    return identifier;
}

- _initWithString:(NSString *)aString;
{
    if (![super init])
        return nil;
    string = [aString retain];
    declarationIndex = NSNotFound;
    return self;
}

- (NSString *)descriptionWithLocale:(NSDictionary *)locale indent:(unsigned)level;
{
    return [NSString stringWithFormat:@"[%@]", string];
}

@end
