// Copyright 1999-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWNetLocation.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/Address.subproj/OWNetLocation.m,v 1.10 2001/02/16 22:17:42 wiml Exp $")

@implementation OWNetLocation

+ (OWNetLocation *)netLocationWithString:(NSString *)aNetLocation;
{
    NSString                   *aUsername = nil, *aPassword = nil;
    NSString		       *aHostname = nil, *aPort = nil;
    NSArray                    *temp;

    if (!aNetLocation)
	return nil;
    aHostname = aNetLocation;
    if ([aHostname containsString:@"@"]) {
	temp = [aHostname componentsSeparatedByString:@"@"];
	aUsername = [temp objectAtIndex:0];
	aHostname = [temp objectAtIndex:1];
	if ([aUsername containsString:@":"]) {
	    temp = [aUsername componentsSeparatedByString:@":"];
	    aUsername = [temp objectAtIndex:0];
	    aPassword = [temp objectAtIndex:1];
	}
    }
    if ([aHostname containsString:@":"]) {
	temp = [aHostname componentsSeparatedByString:@":"];
	aHostname = [temp objectAtIndex:0];
	aPort = [temp objectAtIndex:1];
    }
    return [[[self alloc] initWithUsername:aUsername password:aPassword hostname:aHostname port:aPort] autorelease];
}

- initWithUsername:(NSString *)aUsername password:(NSString *)aPassword
  hostname:(NSString *)aHostname port:(NSString *)aPort;
{
    if (![super init])
	return nil;

    username = [aUsername retain];
    password = [aPassword retain];
    hostname = [aHostname retain];
    port = [aPort retain];

    return self;
}

- (void)dealloc;
{
    [username release];
    [password release];
    [hostname release];
    [port release];
    [shortDisplayName release];
    [super dealloc];
}

- (NSString *)username;
{
    return username;
}

- (NSString *)password;
{
    return password;
}

- (NSString *)hostname;
{
    return hostname;
}

- (NSString *)port;
{
    return port;
}

- (NSString *)displayString;
{
    NSMutableString            *displayString;

    displayString = [NSMutableString stringWithCapacity:[hostname length]];
    if (username) {
	[displayString appendString:username];
	if (password)
	    [displayString appendStrings:@":", username, nil];
	[displayString appendString:@"@"];
    }
    if (hostname)
	[displayString appendString:hostname];
    if (port)
	[displayString appendStrings:@":", port, nil];
    return displayString;
}

- (NSString *)shortDisplayString;
{
    if (!shortDisplayName) {
        NSRange useableRange;

        useableRange = NSMakeRange(0, [hostname length]);
        if ([hostname hasSuffix:NSLocalizedStringFromTableInBundle(@".com", @"OWF", [self bundle], netlocation string to remove from addresses when displaying them in short form)])
            useableRange.length -= 4;
        if (useableRange.length > 4 && [hostname hasPrefix:@"www."]) {
            useableRange.location += 4;
            useableRange.length -= 4;
        }

        shortDisplayName = [[hostname substringWithRange:useableRange] retain];
    }
    return shortDisplayName;
}

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary        *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (username)
	[debugDictionary setObject:username forKey:@"username"];
    if (password)
	[debugDictionary setObject:password forKey:@"password"];
    if (hostname)
	[debugDictionary setObject:hostname forKey:@"hostname"];
    if (port)
	[debugDictionary setObject:port forKey:@"port"];

    return debugDictionary;
}

- (NSString *)shortDescription;
{
    return [self displayString];
}

@end
