// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWCompoundObjectStreamCursor.h,v 1.8 2001/02/15 15:11:56 kc Exp $

#import <OWF/OWCursor.h>

@class NSMutableArray;

@interface OWCompoundObjectStreamCursor : OWCursor <NSCopying>
{
    NSMutableArray *cursors;
    int cursorIndex;
}

// Both of these call [super initFromCursor].
- initFromCursor:(id)aCursor;
- initFromCursor:(id)aCursor andCursor:(id)anotherCursor;

- (id)readObject;
- (void)skipObjects:(int)count;
- (void)ungetObject:(id)anObject;

// These hold on to and modify the cursor they are given.
- (void)appendCursor:(OWCursor *)appendedCursor;
- (void)prependCursor:(OWCursor *)prependedCursor;

@end
